/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import com.idoox.security.pstore.PasswordPropertySerializer;
import com.idoox.security.pstore.UserIteratorImpl;
import com.idoox.security.pstore.X509certPropertySerializer;
import com.idoox.security.pstore.X509certchainPropertySerializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.security.pstore.AbstractUserStore;
import org.idoox.security.pstore.PropertyEntry;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.pstore.UserIterator;
import org.idoox.security.pstore.UserStoreException;
import org.idoox.security.pstore.UserStoreSource;

public class UserStoreImpl
extends AbstractUserStore {
    private static final Map EMPTY_MAP = new HashMap(1);
    private Map users = Collections.synchronizedMap(new HashMap());
    private UserStoreSource source = null;
    private static Map propertySerializers = Collections.synchronizedMap(new HashMap());
    private static boolean initialized = false;

    private static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        propertySerializers.put("password", new PasswordPropertySerializer());
        propertySerializers.put("X509Certificate", new X509certPropertySerializer());
        propertySerializers.put("X509CertificateChain", new X509certchainPropertySerializer());
    }

    public UserStoreImpl() {
    }

    public UserStoreImpl(String password) {
    }

    private void insertUser(String userId, Map properties) throws UserStoreException {
        this.users.put(userId, properties);
        if (this.source == null) {
            return;
        }
        if (properties == null) {
            properties = EMPTY_MAP;
        }
        int size = properties.size();
        PropertyEntry[] pEntries = new PropertyEntry[size];
        Iterator it = properties.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            pEntries[i] = new PropertyEntry();
            pEntries[i].key = (String)it.next();
            pEntries[i].value = this.getPropertySerializer(pEntries[i].key).encode(properties.get(pEntries[i].key));
            ++i;
        }
        UserStoreSource userStoreSource = this.source;
        synchronized (userStoreSource) {
            this.source.addUser(userId, pEntries);
        }
    }

    public void deleteUser(String userId) throws UserStoreException {
        this.users.remove(userId);
        if (this.source == null) {
            return;
        }
        UserStoreSource userStoreSource = this.source;
        synchronized (userStoreSource) {
            this.source.deleteUser(userId);
        }
        this.fireDeleteUserAction(userId);
    }

    public boolean hasUser(String userId, Map filter) {
        if (!this.users.containsKey(userId)) {
            return false;
        }
        if (filter == null || filter.size() == 0) {
            return true;
        }
        Map properties = (Map)this.users.get(userId);
        if (properties == null) {
            return false;
        }
        Iterator it = filter.keySet().iterator();
        while (it.hasNext()) {
            Object incomeKey = it.next();
            if (!properties.containsKey(incomeKey)) {
                return false;
            }
            Object incomeValue = filter.get(incomeKey);
            if (incomeValue == null) continue;
            Object myVal = properties.get(incomeKey);
            if (myVal == null) {
                return false;
            }
            if (incomeValue instanceof Object[]) {
                if (!(myVal instanceof Object[])) {
                    return false;
                }
                if (Arrays.equals((Object[])incomeValue, (Object[])myVal)) continue;
                return false;
            }
            if (incomeValue.equals(myVal)) continue;
            return false;
        }
        return true;
    }

    public Map getUserProperties(String userId) throws UserStoreException {
        return Collections.unmodifiableMap(this.getModifiableUserProperties(userId));
    }

    private Map getModifiableUserProperties(String userId) throws UserStoreException {
        if (!this.users.containsKey(userId)) {
            throw new UserStoreException("user " + userId + " doesn't exist.");
        }
        Map properties = (Map)this.users.get(userId);
        return properties;
    }

    private PropertyEntry[] getUserPropertyEntries(String userId) throws UserStoreException {
        Map properties = this.getModifiableUserProperties(userId);
        return this.getPropertyEntries(properties);
    }

    private PropertyEntry[] getPropertyEntries(Map properties) throws UserStoreException {
        PropertyEntry[] entries = new PropertyEntry[properties.size()];
        Iterator it = properties.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            Object property = properties.get(key);
            entries[i] = new PropertyEntry();
            entries[i].key = key;
            entries[i].value = this.getPropertySerializer(key).encode(property);
            ++i;
        }
        return entries;
    }

    private void editUser(String userId) throws UserStoreException {
        PropertyEntry[] properties = this.getUserPropertyEntries(userId);
        UserStoreSource userStoreSource = this.source;
        synchronized (userStoreSource) {
            this.source.editUser(userId, properties);
        }
    }

    public Object getUserProperty(String userId, String key) throws UserStoreException {
        return this.getModifiableUserProperties(userId).get(key);
    }

    public void removeUserProperty(String userId, String key) throws UserStoreException {
        this.getModifiableUserProperties(userId).remove(key);
        this.editUser(userId);
    }

    public void setUserProperties(String userId, Map properties) throws UserStoreException {
        if (userId == null) {
            throw new UserStoreException("User id cannot be null");
        }
        if (properties == null) {
            properties = EMPTY_MAP;
        }
        if (!this.hasUser(userId, null)) {
            this.insertUser(userId, properties);
            return;
        }
        this.getModifiableUserProperties(userId).putAll(properties);
        this.editUser(userId);
    }

    public void setUserProperty(String userId, String key, Object value) throws UserStoreException {
        if (userId == null) {
            throw new UserStoreException("User id cannot be null");
        }
        if (!this.hasUser(userId, null)) {
            HashMap<String, Object> properties = new HashMap<String, Object>(1);
            properties.put(key, value);
            this.insertUser(userId, properties);
            return;
        }
        this.getModifiableUserProperties(userId).put(key, value);
        this.editUser(userId);
    }

    public UserIterator getUsers() {
        return new UserIteratorImpl(Collections.unmodifiableMap(this.users));
    }

    public UserIterator getUsers(Map filter) {
        HashMap filteredUsers = new HashMap();
        Iterator it = this.users.keySet().iterator();
        String userFilter = (String)filter.get("FILTER_STRING");
        boolean checkStart = false;
        boolean checkEnd = false;
        if (userFilter != null) {
            HashMap newFilter = new HashMap(filter.size());
            newFilter.putAll(filter);
            newFilter.remove("FILTER_STRING");
            filter = newFilter;
            if (userFilter.startsWith("*")) {
                userFilter = userFilter.substring(1);
                checkEnd = true;
            }
            if (userFilter.length() == 0) {
                userFilter = null;
            } else if (userFilter.endsWith("*")) {
                checkStart = true;
                userFilter = userFilter.substring(0, userFilter.length() - 1);
            } else {
                checkStart = !checkEnd;
            }
        }
        while (it.hasNext()) {
            String userId = (String)it.next();
            if (userFilter != null && !this.match(userId, userFilter, checkStart, checkEnd) || !this.hasUser(userId, filter)) continue;
            filteredUsers.put(userId, this.users.get(userId));
        }
        return new UserIteratorImpl(filteredUsers);
    }

    public String[] getUserIds() {
        Set set = this.users.keySet();
        Iterator it = this.users.keySet().iterator();
        String[] retVal = new String[set.size()];
        int i = 0;
        while (it.hasNext()) {
            String userId = (String)it.next();
            if (i == retVal.length) {
                String[] newVal = new String[retVal.length + 10];
                System.arraycopy(retVal, 0, newVal, 0, retVal.length);
                retVal = newVal;
            }
            retVal[i] = userId;
            ++i;
        }
        if (i != retVal.length) {
            String[] newVal = new String[i];
            System.arraycopy(retVal, 0, newVal, 0, i);
            retVal = newVal;
        }
        return retVal;
    }

    public void setUserStoreSource(UserStoreSource source) {
        this.source = source;
    }

    public void setPropertySerializer(String propertyKey, PropertySerializer serializer) throws UserStoreException {
        if (propertySerializers.get(propertyKey) != null) {
            throw new UserStoreException("PropertySerializer for key " + propertyKey + " already exists.");
        }
        propertySerializers.put(propertyKey, serializer);
    }

    public PropertySerializer getPropertySerializer(String propertyKey) throws UserStoreException {
        PropertySerializer ps = (PropertySerializer)propertySerializers.get(propertyKey);
        if (ps == null) {
            throw new UserStoreException("PropertySerializer for key " + propertyKey + " doesn't exist.");
        }
        return ps;
    }

    public Iterator getSupportedAttributes() {
        return Collections.unmodifiableSet(propertySerializers.keySet()).iterator();
    }

    static {
        UserStoreImpl.init();
    }
}

