/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import com.idoox.security.util.CertUtilBase;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.pstore.UserStoreException;

public class UserStoreHelper {
    public static boolean hasUser(UserStore userdb, String userId, Certificate cert) {
        if (cert == null) {
            return false;
        }
        Map properties = null;
        try {
            properties = userdb.getUserProperties(userId);
        }
        catch (UserStoreException e) {
            return false;
        }
        if (properties == null) {
            return false;
        }
        X509Certificate crt = (X509Certificate)properties.get("X509Certificate");
        if (crt != null && UserStoreHelper.compareCert(crt, cert)) {
            return true;
        }
        X509Certificate[] certs = (X509Certificate[])properties.get("X509CertificateChain");
        if (certs == null) {
            return false;
        }
        int j = 0;
        while (j < certs.length) {
            if (UserStoreHelper.compareCert(certs[j], cert)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static boolean compareCert(Certificate cert1, Certificate cert2) {
        return CertUtilBase.compareCert((Certificate)cert1, (Certificate)cert2);
    }
}

