/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import java.util.ArrayList;
import org.systinet.wasp.security.ws.PasswordOption;
import org.systinet.wasp.security.ws.SecurityElement;
import org.systinet.wasp.security.ws.SecurityToken;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;

public class UsernameToken
extends SecurityToken {
    private String alias;
    private String password;
    private PasswordOption passwordOption = PasswordOption.TEXT;
    private boolean noNonceAndCreated = false;

    public UsernameToken(PasswordOption passwordOption) {
        this.passwordOption = passwordOption;
    }

    public UsernameToken(String alias, String password, PasswordOption passwordOption) {
        this.alias = alias;
        this.password = password;
        this.passwordOption = passwordOption;
    }

    public void setNoNonceAndCreated() {
        this.noNonceAndCreated = true;
    }

    protected SecurityTokenConf getSecurityTokenConf(MessageConf messageConf) {
        ArrayList<PropertyConf> properties = new ArrayList<PropertyConf>();
        SecurityTokenConf tokenConf = messageConf.newSecurityToken();
        if (this.getId() != null) {
            tokenConf.setWsuId(this.getId());
        }
        tokenConf.setType("Username");
        PropertyConf propertyConf = tokenConf.newProperty();
        propertyConf.setPropertyName("PasswordType");
        if (this.passwordOption == PasswordOption.TEXT) {
            propertyConf.setPropertyValue("PasswordText");
        } else {
            propertyConf.setPropertyValue("PasswordDigest");
        }
        properties.add(propertyConf);
        if (this.noNonceAndCreated) {
            propertyConf = tokenConf.newProperty();
            propertyConf.setPropertyName("noNonceAndCreated");
            propertyConf.setPropertyValue(Boolean.TRUE.toString());
            properties.add(propertyConf);
        }
        if (this.alias != null) {
            propertyConf = tokenConf.newProperty();
            propertyConf.setPropertyName("alias");
            propertyConf.setPropertyValue(this.alias);
            properties.add(propertyConf);
        }
        if (this.password != null) {
            propertyConf = tokenConf.newProperty();
            propertyConf.setPropertyName("password");
            propertyConf.setPropertyValue(this.password);
            properties.add(propertyConf);
        }
        tokenConf.setProperties(properties.toArray(SecurityToken.NULL_PROPERTY_CONF_ARRAY));
        return tokenConf;
    }

    protected String getTokenReferenceModeHint(SecurityElement securityElement) {
        return "reference";
    }

    protected String getSignatureMethodHint() {
        return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    }

    protected String getEncryptionMethodHint() {
        return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    }

    protected String getKeyEncryptionMethodHint() {
        return null;
    }
}

