/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.crypto.SecretKey;
import org.idoox.util.Base64;
import org.systinet.wasp.security.ws.SecurityElement;
import org.systinet.wasp.security.ws.SecurityToken;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;

public class SharedSecretToken
extends SecurityToken {
    private SecretKey secretKey;

    public SharedSecretToken(String keyName, SecretKey secretKey) {
        this.secretKey = secretKey;
        this.setId(keyName);
    }

    protected SecurityTokenConf getSecurityTokenConf(MessageConf messageConf) {
        SecurityTokenConf tokenConf = messageConf.newSecurityToken();
        if (this.getId() != null) {
            tokenConf.setWsuId(this.getId());
        }
        tokenConf.setType("SymmetricKey");
        ArrayList<PropertyConf> properties = new ArrayList<PropertyConf>();
        PropertyConf propertyConf = tokenConf.newProperty();
        propertyConf.setPropertyName("encodedkey");
        propertyConf.setPropertyValue(Base64.encodeToString((byte[])this.secretKey.getEncoded()));
        properties.add(propertyConf);
        propertyConf = tokenConf.newProperty();
        propertyConf.setPropertyName("keyalgorithm");
        propertyConf.setPropertyValue(this.secretKey.getAlgorithm());
        properties.add(propertyConf);
        tokenConf.setProperties(properties.toArray(SecurityToken.NULL_PROPERTY_CONF_ARRAY));
        return tokenConf;
    }

    protected String getTokenReferenceModeHint(SecurityElement securityElement) {
        return "keyname";
    }

    protected String getSignatureMethodHint() {
        return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    }

    protected String getEncryptionMethodHint() {
        String algorithm = this.secretKey.getAlgorithm();
        if (algorithm.equals("DESede")) {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }
        if (algorithm.equals("AES")) {
            int keyBits = this.secretKey.getEncoded().length * 8;
            switch (keyBits) {
                case 128: {
                    return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
                }
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
                }
            }
            throw new WSSecurityException(new InvalidKeyException("key size " + keyBits));
        }
        throw new WSSecurityException(new NoSuchAlgorithmException(algorithm));
    }

    protected String getKeyEncryptionMethodHint() {
        return null;
    }
}

