/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systinet.wasp.security.ws.Transform;
import org.systinet.wasp.security.ws.conf.ReferenceConf;
import org.systinet.wasp.security.ws.conf.SignatureConf;
import org.systinet.wasp.security.ws.conf.TransformConf;

public abstract class Reference {
    private String expression;
    private String digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
    private List transforms;
    private static final TransformConf[] NULL_TRANSFORM_CONF_ARRAY = new TransformConf[0];

    protected Reference(String expression) {
        this.expression = expression;
    }

    protected String getExpression() {
        return this.expression;
    }

    public void addTransform(Transform transform) {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        this.transforms.add(transform);
    }

    ReferenceConf getReferenceConf(SignatureConf signatureConf) {
        ReferenceConf referenceConf = signatureConf.newReference();
        referenceConf.setRefUri(this.expression);
        referenceConf.setDigestAlgorithm(this.digestAlgorithm);
        if (this.transforms != null) {
            ArrayList<TransformConf> tfs = new ArrayList<TransformConf>();
            Iterator it = this.transforms.iterator();
            while (it.hasNext()) {
                Transform transform = (Transform)it.next();
                TransformConf transformConf = transform.getTransformConf(referenceConf);
                tfs.add(transformConf);
            }
            TransformConf[] tfConfs = tfs.toArray(NULL_TRANSFORM_CONF_ARRAY);
            referenceConf.setTransforms(tfConfs);
        }
        return referenceConf;
    }
}

