/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.systinet.wasp.security.ws.EncryptedData;
import org.systinet.wasp.security.ws.IncomingValidator;
import org.systinet.wasp.security.ws.SecurityElement;
import org.systinet.wasp.security.ws.SecurityToken;
import org.systinet.wasp.security.ws.Signature;
import org.systinet.wasp.security.ws.conf.EncryptedDataConf;
import org.systinet.wasp.security.ws.conf.EncryptedKeyConf;
import org.systinet.wasp.security.ws.conf.ExternalSecurityTokensConf;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.ReferenceListConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.security.ws.conf.SignatureConf;
import org.systinet.wasp.security.ws.conf.WSSEConf;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpoint;

public class MessageSecurity {
    private List sequence = new ArrayList();
    private List extTokens = null;
    private MessageConf messageConf = null;
    private WSSEConf securityConf = null;
    private IncomingValidator validator = null;
    private boolean acceptUsernameTokenWithoutNonceAndCreated = false;
    private boolean createTimestampHeader = false;
    private boolean ignoreTimestampHeaderExpiration = false;
    private String wsseNamespace = null;
    private String wsuNamespace = null;
    private boolean readonly = false;
    private static final SecurityTokenConf[] NULL_SECURITY_TOKEN_CONF_ARRAY = new SecurityTokenConf[0];
    private static final SignatureConf[] NULL_SIGNATURE_CONF_ARRAY = new SignatureConf[0];
    private static final EncryptedDataConf[] NULL_ENCRYPTED_DATA_CONF_ARRAY = new EncryptedDataConf[0];
    private static final EncryptedKeyConf[] NULL_ENCRYPTED_KEY_CONF_ARRAY = new EncryptedKeyConf[0];
    private static final ReferenceListConf[] NULL_REFERENCE_LIST_CONF_ARRAY = new ReferenceListConf[0];
    private static final String ILE_MESSAGE = "setContextSecurity or setCallSecurity has already been called";
    private Integer timestampHeaderExpiration = null;
    private String timestampId = null;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$MessageConf;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$WSSEConf;

    public void addToken(SecurityToken token) {
        if (this.readonly) {
            throw new IllegalStateException(ILE_MESSAGE);
        }
        this.sequence.add(token);
        this.invalidateConfs();
    }

    public void addExternalToken(SecurityToken token) {
        if (this.readonly) {
            throw new IllegalStateException(ILE_MESSAGE);
        }
        if (this.extTokens == null) {
            this.extTokens = new ArrayList();
        }
        this.extTokens.add(token);
        this.invalidateConfs();
    }

    public void addSecurityElement(SecurityElement securityElement) {
        if (this.readonly) {
            throw new IllegalStateException(ILE_MESSAGE);
        }
        this.sequence.add(securityElement);
        this.invalidateConfs();
    }

    public void setAcceptUsernameTokenWithoutNonceAndCreated() {
        if (this.readonly) {
            throw new IllegalStateException(ILE_MESSAGE);
        }
        this.acceptUsernameTokenWithoutNonceAndCreated = true;
        this.invalidateConfs();
    }

    public void setCreateTimestampHeader() {
        if (this.readonly) {
            throw new IllegalStateException(ILE_MESSAGE);
        }
        this.createTimestampHeader = true;
        this.invalidateConfs();
    }

    public void setTimestampId(String id) {
        if (this.readonly) {
            throw new IllegalStateException(ILE_MESSAGE);
        }
        this.timestampId = id;
        this.invalidateConfs();
    }

    public void setTimestampHeaderExpiration(int millis) {
        this.timestampHeaderExpiration = new Integer(millis);
    }

    public void setIgnoreTimestampHeaderExpiration() {
        if (this.readonly) {
            throw new IllegalStateException(ILE_MESSAGE);
        }
        this.ignoreTimestampHeaderExpiration = true;
        this.invalidateConfs();
    }

    public void setContextSecurity(ServiceClient serviceClient) {
        Map contextData = serviceClient.getContext().getContextData();
        contextData.put("securityConfiguration", this.getContextSecurityConfiguration());
        contextData.put("securityMessageConfiguration", this.getContextMessageConfiguration());
        this.setValidator(contextData);
        this.readonly = true;
    }

    public void setCallSecurity(ServiceClient serviceClient) {
        Map contextData = serviceClient.getCallContext().getContextData();
        contextData.put("securityConfiguration", this.getSecurityConfiguration(serviceClient.getContext().getContextData()));
        contextData.put("securityMessageConfiguration", this.getMessageConfiguration());
        this.readonly = true;
    }

    public void setContextSecurity(ServiceEndpoint serviceEndpoint) {
        Map contextData = serviceEndpoint.getContext().getContextData();
        contextData.put("securityConfiguration", this.getContextSecurityConfiguration());
        contextData.put("securityMessageConfiguration", this.getContextMessageConfiguration());
        this.setValidator(contextData);
        this.readonly = true;
    }

    public void setCallSecurity(ServiceEndpoint serviceEndpoint) {
        Map contextData = Current.getCallContext().getContextData();
        contextData.put("securityConfiguration", this.getSecurityConfiguration(serviceEndpoint.getContext().getContextData()));
        contextData.put("securityMessageConfiguration", this.getMessageConfiguration());
        this.readonly = true;
    }

    public void setValidator(IncomingValidator validator) {
        this.validator = validator;
    }

    public void setWsseNamespace(String wsseNamespace) {
        this.wsseNamespace = wsseNamespace;
    }

    public void setWsuNamespace(String wsuNamespace) {
        this.wsuNamespace = wsuNamespace;
    }

    private void doFinalContext() {
        this.doFinal(null);
    }

    private void doFinalCall(Map contextData) {
        if (this.extTokens != null) {
            throw new IllegalStateException("external tokens may only be used in context-scope configuration");
        }
        this.doFinal(contextData);
    }

    private void doFinal(Map contextData) {
        Configurable wsConfigurable = Configurator.newRuntimeConfigurable();
        MessageConf messageConf = (MessageConf)wsConfigurable.narrow(class$org$systinet$wasp$security$ws$conf$MessageConf == null ? (class$org$systinet$wasp$security$ws$conf$MessageConf = MessageSecurity.class$("org.systinet.wasp.security.ws.conf.MessageConf")) : class$org$systinet$wasp$security$ws$conf$MessageConf);
        Configurable configurable = Configurator.newRuntimeConfigurable();
        WSSEConf securityConf = (WSSEConf)configurable.narrow(class$org$systinet$wasp$security$ws$conf$WSSEConf == null ? (class$org$systinet$wasp$security$ws$conf$WSSEConf = MessageSecurity.class$("org.systinet.wasp.security.ws.conf.WSSEConf")) : class$org$systinet$wasp$security$ws$conf$WSSEConf);
        HashMap<SecurityToken, SecurityTokenConf> tokens = new HashMap<SecurityToken, SecurityTokenConf>();
        HashMap<SecurityTokenConf, SecurityTokenConf> externalTokens = new HashMap<SecurityTokenConf, SecurityTokenConf>();
        ArrayList<EncryptedDataConf> encData = new ArrayList<EncryptedDataConf>();
        ArrayList<EncryptedKeyConf> encKeys = new ArrayList<EncryptedKeyConf>();
        ArrayList<ReferenceListConf> refLists = new ArrayList<ReferenceListConf>();
        ArrayList<SignatureConf> signatures = new ArrayList<SignatureConf>();
        if (this.extTokens != null) {
            Iterator it = this.extTokens.iterator();
            while (it.hasNext()) {
                SecurityToken token = (SecurityToken)it.next();
                SecurityTokenConf tokenConf = token.getSecurityTokenConf(messageConf);
                externalTokens.put(tokenConf, tokenConf);
            }
        }
        int idx = 0;
        Iterator it = this.sequence.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof SecurityToken) {
                SecurityToken token = (SecurityToken)o;
                SecurityTokenConf tokenConf = token.getSecurityTokenConf(messageConf);
                tokenConf.setOrder(new Integer(idx));
                tokens.put(token, tokenConf);
            } else if (o instanceof Signature) {
                Signature signature = (Signature)o;
                SignatureConf sigConf = signature.getSignatureConf(messageConf);
                sigConf.setOrder(new Integer(idx));
                signatures.add(sigConf);
                idx = this.adjustTokenOrder(tokens, signature.getToken(), idx, messageConf, externalTokens, contextData);
            } else if (o instanceof EncryptedData) {
                EncryptedData encryptedData = (EncryptedData)o;
                EncryptedDataConf[] encDataConf = encryptedData.getEncryptedDataConf(messageConf);
                EncryptedKeyConf encKeyConf = encryptedData.getEncryptedKeyConf(messageConf);
                ReferenceListConf refListConf = encryptedData.getReferenceListConf(messageConf);
                int n = encDataConf.length;
                int i = 0;
                while (i < n) {
                    encDataConf[i].setOrder(new Integer(idx++));
                    encData.add(encDataConf[i]);
                    ++i;
                }
                if (encKeyConf != null) {
                    encKeyConf.setOrder(new Integer(idx + 1));
                    encKeys.add(encKeyConf);
                }
                if (refListConf != null) {
                    refListConf.setOrder(new Integer(idx + 1));
                    refLists.add(refListConf);
                }
                idx = this.adjustTokenOrder(tokens, encryptedData.getToken(), idx, messageConf, externalTokens, contextData);
            }
            idx += 10;
        }
        SignatureConf[] sigConfs = signatures.toArray(NULL_SIGNATURE_CONF_ARRAY);
        EncryptedDataConf[] encDataConfs = encData.toArray(NULL_ENCRYPTED_DATA_CONF_ARRAY);
        EncryptedKeyConf[] encKeyConfs = encKeys.toArray(NULL_ENCRYPTED_KEY_CONF_ARRAY);
        ReferenceListConf[] refListConfs = refLists.toArray(NULL_REFERENCE_LIST_CONF_ARRAY);
        SecurityTokenConf[] tokenConfs = tokens.values().toArray(NULL_SECURITY_TOKEN_CONF_ARRAY);
        messageConf.setSecurityTokens(tokenConfs);
        messageConf.setSignatures(sigConfs);
        messageConf.setEncryptedData(encDataConfs);
        messageConf.setEncryptedKeys(encKeyConfs);
        messageConf.setReferenceLists(refListConfs);
        if (tokenConfs.length == 0 && sigConfs.length == 0 && encDataConfs.length == 0) {
            messageConf.setNoSecurityHeader(Boolean.TRUE);
        } else {
            messageConf.setNoSecurityHeader(Boolean.FALSE);
        }
        if (this.createTimestampHeader) {
            messageConf.setCreateTimestampHeader(Boolean.TRUE);
        }
        if (this.wsseNamespace != null) {
            messageConf.setWsseNamespace(this.wsseNamespace);
        }
        if (this.wsuNamespace != null) {
            messageConf.setWsuNamespace(this.wsuNamespace);
        }
        this.messageConf = messageConf;
        SecurityTokenConf[] externalTokenConfs = externalTokens.values().toArray(NULL_SECURITY_TOKEN_CONF_ARRAY);
        ExternalSecurityTokensConf extSecToken = securityConf.newExternalSecurityTokens();
        extSecToken.setSecurityTokens(externalTokenConfs);
        securityConf.setExternalSecurityTokens(extSecToken);
        if (this.timestampHeaderExpiration != null) {
            securityConf.setTimestampHeaderExpiration(this.timestampHeaderExpiration);
        }
        if (this.timestampId != null) {
            messageConf.setTimestampId(this.timestampId);
        }
        if (this.acceptUsernameTokenWithoutNonceAndCreated) {
            securityConf.setNoUsernameTokenValidation(Boolean.TRUE);
        }
        if (this.ignoreTimestampHeaderExpiration) {
            securityConf.setIgnoreTimestampHeaderExpiration(Boolean.TRUE);
        }
        this.securityConf = securityConf;
    }

    private int adjustTokenOrder(Map tokens, SecurityToken token, int idx, MessageConf messageConf, Map externalTokens, Map contextData) {
        if (tokens.containsKey(token)) {
            SecurityTokenConf tokenConf = (SecurityTokenConf)tokens.get(token);
            tokenConf.setOrder(new Integer(idx += 5));
        } else {
            SecurityTokenConf[] extTokenConf;
            ExternalSecurityTokensConf extSecTokensConf;
            WSSEConf securityConf;
            SecurityTokenConf tokenConf;
            Iterator<Object> it;
            if (this.extTokens != null) {
                it = this.extTokens.iterator();
                while (it.hasNext()) {
                    SecurityToken secToken = (SecurityToken)it.next();
                    if (!token.getId().equals(secToken.getId())) continue;
                    return idx;
                }
            }
            it = externalTokens.keySet().iterator();
            while (it.hasNext()) {
                tokenConf = (SecurityTokenConf)it.next();
                if (!token.getId().equals(tokenConf.getWsuId())) continue;
                return idx;
            }
            if (contextData != null && (securityConf = (WSSEConf)contextData.get("securityConfiguration")) != null && (extSecTokensConf = securityConf.getExternalSecurityTokens()) != null && (extTokenConf = extSecTokensConf.getSecurityTokens()) != null) {
                int n = extTokenConf.length;
                int i = 0;
                while (i < n) {
                    if (token.getId().equals(extTokenConf[i].getWsuId())) {
                        return idx;
                    }
                    ++i;
                }
            }
            tokenConf = token.getSecurityTokenConf(messageConf);
            externalTokens.put(token, tokenConf);
        }
        return idx;
    }

    private void invalidateConfs() {
        this.messageConf = null;
        this.securityConf = null;
    }

    private WSSEConf getSecurityConfiguration(Map contextData) {
        if (this.securityConf == null) {
            this.doFinalCall(contextData);
        }
        return this.securityConf;
    }

    private WSSEConf getContextSecurityConfiguration() {
        if (this.securityConf == null) {
            this.doFinalContext();
        }
        return this.securityConf;
    }

    private MessageConf getMessageConfiguration() {
        if (this.messageConf == null) {
            this.doFinalCall(null);
        }
        return this.messageConf;
    }

    private MessageConf getContextMessageConfiguration() {
        if (this.messageConf == null) {
            this.doFinalContext();
        }
        return this.messageConf;
    }

    private void setValidator(Map contextData) {
        if (this.validator != null) {
            contextData.put("wssecurity_validator_instance_name", this.validator);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

