/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.provider;

import com.idoox.debug.Category;
import com.idoox.wasp.Constants;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.iface.WSTimestampHeader;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import com.systinet.wasp.security.ws.provider.WSProviderHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.RawOutputMessage;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Document;

public class WSSecurityOutputMessage
extends RawOutputMessage {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.provider.WSSecurityOutputMessage");
    private OutputMessage outputMessage;
    private MessageConf senderConf;
    private WSSecurity wsSecurity;
    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private boolean closed = false;
    private int state = 0;
    private volatile boolean applied = false;
    private boolean nextPart = false;
    private boolean faultGenerated = false;

    public WSSecurityOutputMessage(OutputMessage outputMessage, WSSecurity wsSecurity) {
        super((OutputStream)outputMessage);
        this.outputMessage = outputMessage;
        this.wsSecurity = wsSecurity;
    }

    public void write(int i) throws IOException {
        if (!this.applied) {
            this.outputStream.write(i);
        } else {
            this.outputMessage.write(i);
        }
    }

    public void write(byte[] bytes) throws IOException {
        if (!this.applied) {
            this.outputStream.write(bytes);
        } else {
            this.outputMessage.write(bytes);
        }
    }

    public void write(byte[] bytes, int i, int i1) throws IOException {
        if (!this.applied) {
            this.outputStream.write(bytes, i, i1);
        } else {
            this.outputMessage.write(bytes, i, i1);
        }
    }

    public void flush() throws IOException {
        if (!this.applied) {
            this.outputStream.flush();
        } else {
            this.outputMessage.flush();
        }
    }

    public void setStatusCode(int sc) {
        if (sc >= 500) {
            this.faultGenerated = true;
        }
        this.outputMessage.setStatusCode(sc);
    }

    public void setStringHeader(String name, String value) {
        this.outputMessage.setStringHeader(name, value);
    }

    public void nextPart() throws IOException {
        this.nextPart = true;
        if (!this.applied) {
            this.applied = true;
            this.apply();
        }
        this.outputMessage.nextPart();
    }

    public void close() throws IOException {
        if (!this.applied) {
            this.applied = true;
            this.apply();
        }
        this.outputMessage.close();
    }

    public void setMultipartType(String type) throws IOException {
        this.outputMessage.setMultipartType(type);
    }

    public void apply() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        byte[] messageBytes = this.outputStream.toByteArray();
        if (messageBytes.length == 0) {
            this.outputStream.close();
            this.outputMessage.close();
            return;
        }
        this.senderConf = WSSecurityHelper.getSenderConf();
        boolean unsecure = false;
        CallContext callContext = Current.getCallContext();
        Boolean tmpBoolean = (Boolean)callContext.getContextData().get(WSSecurityImpl.UNSESURE_OUTPUT);
        WSSecurityException incomingEx = (WSSecurityException)((Object)callContext.getContextData().get("incomingException"));
        if (this.senderConf != null && this.senderConf.getSecureFault() != null && !this.senderConf.getSecureFault().booleanValue() && (this.faultGenerated || incomingEx != null || tmpBoolean != null && tmpBoolean.booleanValue())) {
            unsecure = true;
        }
        boolean bytesWritten = false;
        if (unsecure) {
            if (incomingEx != null) {
                try {
                    this.outputMessage.setStatusCode(500);
                    this.serializeWSSecurityFault(this.outputMessage, incomingEx);
                    bytesWritten = true;
                }
                catch (SOAPException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (!bytesWritten) {
                this.outputMessage.write(messageBytes);
                bytesWritten = true;
            }
            return;
        }
        try {
            Document messageDoc = this.createMessageDOM(messageBytes);
            Boolean createTimestampHeader = this.senderConf.getCreateTimestampHeader();
            if (createTimestampHeader == null) {
                createTimestampHeader = Boolean.FALSE;
            }
            try {
                WSTimestampHeader timestampHeader = null;
                if (createTimestampHeader.booleanValue()) {
                    timestampHeader = this.wsSecurity.createTimestampHeader(this.senderConf, messageDoc);
                }
                this.wsSecurity.createSecurityHeader(this.senderConf, messageDoc, timestampHeader == null ? null : timestampHeader.getTimestampElement());
                messageBytes = this.wsSecurity.byteArrayFromDOM(messageDoc);
            }
            catch (WSSecurityException e) {
                if (Current.getProcessingType() == 2) {
                    this.outputMessage.setStatusCode(500);
                    this.serializeWSSecurityFault(this.outputMessage, e);
                    bytesWritten = true;
                }
                throw e;
            }
            if (!bytesWritten) {
                this.outputMessage.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes(Constants.UTF_8));
                this.outputMessage.write(messageBytes);
            }
            this.outputStream.close();
        }
        catch (Throwable e) {
            log.error("Exception caught during WS-Security processing", e);
            throw new WSSecurityException(null, e.getMessage());
        }
    }

    private void serializeWSSecurityFault(OutputMessage outputMessage, WSSecurityException e) throws SOAPException, IOException {
        log.error("", (Throwable)((Object)e));
        SOAPMessage soapMessage = MessageFactory.newInstance().createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPFault soapFault = soapPart.getEnvelope().getBody().addFault();
        String wsseNamespace = null;
        if (this.senderConf != null) {
            wsseNamespace = this.senderConf.getWsseNamespace();
        }
        if (wsseNamespace == null) {
            wsseNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        }
        soapFault.addNamespaceDeclaration(WSSecurityImpl.getWssePrefix(), wsseNamespace);
        soapFault.setFaultCode(e.getFaultCode());
        if (((Throwable)((Object)e)).getMessage() != null) {
            soapFault.setFaultString(((Throwable)((Object)e)).getMessage());
        } else {
            soapFault.setFaultString("");
        }
        soapMessage.writeTo((OutputStream)outputMessage);
        outputMessage.setStatusCode(500);
    }

    private Document createMessageDOM(byte[] messageBytes) {
        if (messageBytes == null || messageBytes.length == 0) {
            return null;
        }
        try {
            int i = 0;
            i = 0;
            while (i < messageBytes.length) {
                if (messageBytes[i] == 60 && messageBytes[i + 1] == 63 && messageBytes[i + 2] == 120 && messageBytes[i + 3] == 109 && messageBytes[i + 4] == 108) break;
                ++i;
            }
            int j = 0;
            while (j < i) {
                byte messageByte = messageBytes[j];
                this.outputMessage.write(messageByte);
                ++j;
            }
            Document dom = null;
            if (i != messageBytes.length) {
                StringBuffer stringBuffer = new StringBuffer();
                int j2 = i;
                while (j2 < messageBytes.length - i) {
                    byte messageByte = messageBytes[j2];
                    stringBuffer.append((char)messageByte);
                    ++j2;
                }
                dom = WSProviderHelper.getDocumentBuilder().parse(new ByteArrayInputStream(messageBytes, i, messageBytes.length - i));
            } else {
                dom = WSProviderHelper.getDocumentBuilder().parse(new ByteArrayInputStream(messageBytes));
            }
            return dom;
        }
        catch (Exception e) {
            log.error("Unable to parse the message", (Throwable)e);
            try {
                log.error(new String(messageBytes, Constants.UTF_8));
            }
            catch (UnsupportedEncodingException e1) {
                log.error("", (Throwable)e1);
                throw WSSecurityException.INVALID_SECURITY;
            }
            throw WSSecurityException.INVALID_SECURITY;
        }
    }
}

