/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethod;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.algorithms.encryption.params.OAEPParams;
import com.systinet.wasp.security.secext.encryption.CipherData;
import com.systinet.wasp.security.secext.encryption.EncryptedKey;
import com.systinet.wasp.security.secext.encryption.Reference;
import com.systinet.wasp.security.secext.encryption.ReferenceList;
import com.systinet.wasp.security.secext.encryption.XMLCipher;
import com.systinet.wasp.security.secext.encryption.XMLEncryptionException;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.ws.impl.EncryptedDataObject;
import com.systinet.wasp.security.ws.impl.EncryptedTypeObject;
import com.systinet.wasp.security.ws.impl.WSKeyInfo;
import com.systinet.wasp.security.ws.impl.WSKeyInfoImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.crypto.spec.SecretKeySpec;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.EncryptedKeyConf;
import org.systinet.wasp.security.ws.conf.EncryptionReferenceConf;
import org.systinet.wasp.security.ws.conf.KeyInfoConf;
import org.systinet.wasp.security.ws.conf.OrderedElementConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.w3c.dom.Element;

public class EncryptedKeyObject
extends EncryptedTypeObject {
    private static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$ws$impl$EncryptedKeyObject == null ? (class$com$systinet$wasp$security$ws$impl$EncryptedKeyObject = EncryptedKeyObject.class$("com.systinet.wasp.security.ws.impl.EncryptedKeyObject")) : class$com$systinet$wasp$security$ws$impl$EncryptedKeyObject).getName());
    protected EncryptedKeyConf encryptedKeyConf;
    protected HashMap decryptedKeyMap = new HashMap();
    protected byte[] transportedKeyBytes;
    protected byte[] encryptingIV;
    protected WSKeyInfo wsKeyInfo;
    protected XMLCipher.Factory factory;
    protected Element encryptedKeyElement;
    public static final int KEYUSAGE_ENCRYPTION = 1;
    public static final int KEYUSAGE_DECRYPTION = 2;
    static /* synthetic */ Class class$com$systinet$wasp$security$ws$impl$EncryptedKeyObject;

    public EncryptedKeyObject(SecurityContext securityContext, Element encryptedKeyElement) throws WSSecurityException {
        super(securityContext, encryptedKeyElement);
        try {
            this.factory = XMLCipher.getFactory(this.getSecurityContext().getMessageDocument());
            this.encryptedKeyElement = encryptedKeyElement;
            EncryptedKey encryptedKey = this.factory.newEncryptedKey(encryptedKeyElement);
            if (encryptedKey == null) {
                cat.error("encryptedKey load failed");
                throw WSSecurityException.INVALID_SECURITY;
            }
            this.setEncryptedTypeHolder(encryptedKey);
            this.wsKeyInfo = new WSKeyInfoImpl((WSSecurityObject)this, encryptedKey.getKeyInfo());
            ReferenceList rl = ((EncryptedKey)this.getEncryptedTypeHolder()).getReferenceList();
            if (rl == null || rl.isEmpty()) {
                cat.error("EncryptedKey has no references; id=" + this.getWsuId());
                throw WSSecurityException.INVALID_SECURITY;
            }
            Iterator it = rl.getReferences();
            while (it.hasNext()) {
                String URI2 = ((Reference)it.next()).getURI();
                if (!URI2.startsWith("#")) {
                    cat.error("Reference to encrypted type must by local, but it is \"" + URI2 + "\"");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                String id = URI2.substring(1);
                EncryptedTypeObject eth = (EncryptedTypeObject)this.getSecurityContext().resolveSecurityObjectById(id);
                if (eth != null) continue;
                Element el = this.getSecurityContext().resolveElementById(id);
                if (el != null) {
                    if ("EncryptedKey".equals(el.getLocalName())) {
                        eth = new EncryptedKeyObject((SecurityContext)this.getSecurityContext(), el);
                    } else if ("EncryptedData".equals(el.getLocalName())) {
                        eth = new EncryptedDataObject((SecurityContext)this.getSecurityContext(), el);
                    } else {
                        cat.error("unknown encrypted tag \"" + el.getLocalName() + "\" referenced from encryptedKey; id=" + this.getWsuId());
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    eth.setEncryptingKey(this);
                    this.getSecurityContext().addSecurityObject(eth);
                    continue;
                }
                cat.error("Cannot resolve encryptedData id=" + id);
                throw WSSecurityException.INVALID_SECURITY;
            }
        }
        catch (XMLEncryptionException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.getSecurityContext().addSecurityObject(this);
    }

    public EncryptedKeyObject(SecurityContext securityContext, OrderedElementConf conf) throws WSSecurityException {
        super(securityContext, conf);
        this.encryptedKeyConf = (EncryptedKeyConf)conf;
        if (this.encryptedKeyConf == null) {
            cat.error("encryptedKey configuration is null");
            throw WSSecurityException.INVALID_SECURITY;
        }
        try {
            int i;
            this.factory = XMLCipher.getFactory(this.getSecurityContext().getMessageDocument());
            EncryptedKey ek = this.factory.newEncryptedKey(this.factory.newCipherData(1));
            String encryptionMethodAlgorithm = this.encryptedKeyConf.getEncryptionMethodAlgorithm();
            if (encryptionMethodAlgorithm == null) {
                encryptionMethodAlgorithm = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            }
            com.systinet.wasp.security.secext.encryption.EncryptionMethod em = this.factory.newEncryptionMethod(encryptionMethodAlgorithm);
            PropertyConf[] emprop = this.encryptedKeyConf.getEncryptionMethodProperties();
            if (em.getAlgorithm().equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                String digest = null;
                byte[] params = null;
                if (emprop != null) {
                    i = 0;
                    while (i < emprop.length) {
                        if ("OAEPParams".equals(emprop[i].getPropertyName())) {
                            params = Base64.decode(emprop[i].getPropertyValue());
                        } else if ("OAEPDigest".equals(emprop[i].getPropertyName())) {
                            digest = emprop[i].getPropertyValue();
                        } else {
                            cat.error("encryptedKey has encryption method properties that selected algorithm does not supports");
                            throw WSSecurityException.INVALID_SECURITY;
                        }
                        ++i;
                    }
                }
                if (digest == null) {
                    cat.error("RSA-OAEP algorithm's digest parameter is mandatory");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                if (params != null) {
                    em.setOAEPparams(Base64.encode(params).getBytes());
                }
                em.setOAEPDigestAlgorithm(digest);
            } else if (emprop != null && emprop.length != 0) {
                cat.error("encryptedKey has encryption method properties that selected algorithm does not supports");
                throw WSSecurityException.INVALID_SECURITY;
            }
            ek.setEncryptionMethod(em);
            ek.setId(this.encryptedKeyConf.getWsuId());
            this.wsKeyInfo = new WSKeyInfoImpl((WSSecurityObject)this, this.encryptedKeyConf.getKeyInfo());
            this.setEncryptedTypeHolder(ek);
            EncryptionReferenceConf[] refs = this.encryptedKeyConf.getReferences();
            if (refs == null || refs.length == 0) {
                cat.error("EncryptedKey has no references; id=" + this.encryptedKeyConf.getWsuId());
                throw WSSecurityException.INVALID_SECURITY;
            }
            ReferenceList rl = this.factory.newReferenceList();
            ek.setReferenceList(rl);
            i = 0;
            while (i < refs.length) {
                String URI2 = refs[i].getRefUri();
                if (URI2 == null) {
                    cat.error("EncryptedKey reference's URI is null");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                if (!URI2.startsWith("#")) {
                    cat.error("EncryptedKey can have local reference only");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                WSSecurityObject o = this.getSecurityContext().resolveSecurityObjectById(URI2.substring(1));
                if (o == null) {
                    cat.error("Cannot find referenced object from EncryptedKey; URI=" + URI2);
                    throw WSSecurityException.INVALID_SECURITY;
                }
                if (!(o instanceof EncryptedTypeObject)) {
                    cat.error("Referenced object from EncryptedKey is not neither EncryptedData nor EncryptedKey; URI=" + URI2);
                    throw WSSecurityException.INVALID_SECURITY;
                }
                if (o instanceof EncryptedDataObject) {
                    ((EncryptedDataObject)o).setReferenced();
                }
                this.addReference((EncryptedTypeObject)o);
                ++i;
            }
            this.encryptingIV = this.encryptedKeyConf.getIV();
            this.transportedKeyBytes = this.encryptedKeyConf.getEncodedStoredKey();
            this.generateTransportedKey();
        }
        catch (XMLEncryptionException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        catch (Base64DecodingException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.getSecurityContext().addSecurityObject(this);
    }

    public void doFinal() throws WSSecurityException {
        if (this.getMode() == 0) {
            this.doFinalEncryption();
        } else {
            this.doFinalDecryption();
        }
    }

    public Key getKey(int keyUsage) throws WSSecurityException {
        if (keyUsage != 2 && keyUsage != 1) {
            cat.error("wrong key usage");
            throw WSSecurityException.INVALID_SECURITY;
        }
        if (this.getEncryptingKey() != null) {
            if (this.wsKeyInfo.getWrappedKeyInfo() != null) {
                cat.error("EncryptedKey is encrypted by another EncryptedKey, but it has KeyInfo also");
                throw WSSecurityException.INVALID_SECURITY;
            }
            return this.getEncryptingKey().getTransportedKey(this);
        }
        Key key = null;
        if (keyUsage == 1) {
            key = this.wsKeyInfo.getEncryptingKey();
            if (key != null) {
                return key;
            }
            cat.error("There is not suitable key for encryption in encryptedKey; id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        key = this.wsKeyInfo.getDecryptingKey();
        if (key != null) {
            return key;
        }
        cat.error("There is not suitable key for decryption in encryptedKey; id=" + this.getWsuId());
        throw WSSecurityException.INVALID_SECURITY;
    }

    public Key getTransportedKey(EncryptedTypeObject requestor) throws WSSecurityException {
        if (requestor == null) {
            cat.error("transported key requestor is null");
            throw WSSecurityException.INVALID_SECURITY;
        }
        EncryptedTypeObject[] refs = this.getReferences();
        if (refs.length == 0) {
            cat.error("encryptedKey has no any referencem; id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        boolean requestorOK = false;
        int i = 0;
        while (i < refs.length) {
            if (requestor == refs[i]) {
                requestorOK = true;
            }
            ++i;
        }
        if (!requestorOK) {
            cat.error("invalid transported key requestor");
            throw WSSecurityException.INVALID_SECURITY;
        }
        EncryptionMethod requestorEncryptionMethod = requestor.getEncryptionMethod();
        Key key = (Key)this.decryptedKeyMap.get(requestorEncryptionMethod.getAlgorithmURI());
        if (key != null) {
            return key;
        }
        if (this.getMode() == 1) {
            CipherData cd = this.getEncryptedTypeHolder().getCipherData();
            if (cd.getDataType() == 2) {
                cat.error("Cipher Reference is not supported");
                throw WSSecurityException.INVALID_SECURITY;
            }
            try {
                Key encryptionKey = this.getKey(2);
                byte[] encryptedKeyBytes = Base64.decode(cd.getCipherValue().getValue());
                key = this.getEncryptionMethod().unwrap(encryptedKeyBytes, encryptionKey, requestorEncryptionMethod.getAlgorithmURI());
                this.decryptedKeyMap.put(requestorEncryptionMethod.getAlgorithmURI(), key);
                return key;
            }
            catch (Base64DecodingException e) {
                cat.error("", (Throwable)e);
                throw WSSecurityException.INVALID_SECURITY;
            }
            catch (XMLSecurityException e) {
                cat.error("", (Throwable)e);
                throw WSSecurityException.INVALID_SECURITY;
            }
        }
        key = WSSecurityHelper.createKeyFromBytes(this.transportedKeyBytes, requestorEncryptionMethod);
        this.decryptedKeyMap.put(requestorEncryptionMethod.getAlgorithmURI(), key);
        return key;
    }

    private void generateTransportedKey() throws WSSecurityException {
        if (this.transportedKeyBytes != null) {
            return;
        }
        EncryptedTypeObject[] refs = this.getReferences();
        if (refs.length == 0) {
            cat.error("encryptedKey has no any referencee; id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        int requiredKeySize = -1;
        int i = 0;
        while (i < refs.length) {
            String palgo = refs[i].getEncryptionMethod().getAlgorithmURI();
            if (palgo == null) {
                cat.error("referencee does not specify algorithm id=" + refs[i].getWsuId());
                throw WSSecurityException.UNSUPPORTED_ALGORITHM;
            }
            int keySize = WSSecurityHelper.getKeyLength(palgo);
            if (keySize < 0) {
                cat.error("unknown key size for algorithm " + palgo);
                throw WSSecurityException.UNSUPPORTED_ALGORITHM;
            }
            if (requiredKeySize < 0) {
                requiredKeySize = keySize;
            } else if (requiredKeySize != keySize) {
                cat.error("referencee requires different key size than other referencees id=" + refs[i].getWsuId());
                throw WSSecurityException.UNSUPPORTED_ALGORITHM;
            }
            ++i;
        }
        if (requiredKeySize < 0) {
            cat.error("unknown key size for referencees  of encryptedkey; id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.transportedKeyBytes = WSSecurityHelper.getRandomBytes(requiredKeySize);
    }

    public EncryptedTypeObject[] getReferences() throws WSSecurityException {
        LinkedList<EncryptedTypeObject> encryptedTypes = new LinkedList<EncryptedTypeObject>();
        ReferenceList rl = ((EncryptedKey)this.getEncryptedTypeHolder()).getReferenceList();
        if (rl == null) {
            return new EncryptedTypeObject[0];
        }
        Iterator it = rl.getReferences();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            String URI2 = ref.getURI();
            if (!URI2.startsWith("#")) {
                cat.error("encryptedKey supports local reference only");
                throw WSSecurityException.INVALID_SECURITY;
            }
            EncryptedTypeObject eth = (EncryptedTypeObject)this.getSecurityContext().resolveSecurityObjectById(URI2.substring(1));
            if (eth == null) continue;
            encryptedTypes.add(eth);
        }
        return encryptedTypes.toArray(new EncryptedTypeObject[0]);
    }

    protected void addReference(EncryptedTypeObject encryptedType) throws WSSecurityException {
        encryptedType.setEncryptingKey(this);
        ReferenceList rl = ((EncryptedKey)this.getEncryptedTypeHolder()).getReferenceList();
        String URI2 = "#" + encryptedType.getWsuId();
        Reference ref = encryptedType.getType() == 1 ? ReferenceList.newKeyReference(URI2) : ReferenceList.newDataReference(URI2);
        rl.add(ref);
    }

    protected void doFinalEncryption() throws WSSecurityException {
        this.wsKeyInfo.doFinal();
        this.getEncryptedTypeHolder().setKeyInfo(this.wsKeyInfo.getWrappedKeyInfo());
        EncryptionMethod em = this.getEncryptionMethod();
        if (!em.getUsableInEncryptedKey()) {
            cat.error("algorithm " + em.getAlgorithmURI() + " is not suitable EncryptedKey id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        SecretKeySpec secretKey = new SecretKeySpec(this.transportedKeyBytes, "");
        if (this.encryptingIV == null && em.getIvLength() > 0) {
            this.encryptingIV = WSSecurityHelper.getRandomBytes(em.getIvLength());
        }
        Key encryptingKey = this.getKey(1);
        byte[] encryptedKey = null;
        try {
            encryptedKey = this.encryptingIV == null ? em.wrap(secretKey, encryptingKey) : em.wrap(secretKey, encryptingKey, this.encryptingIV);
        }
        catch (XMLSecurityException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        try {
            String base64data = Base64.encode(encryptedKey);
            this.getEncryptedTypeHolder().getCipherData().setCipherValue(this.factory.newCipherValue(base64data));
        }
        catch (XMLEncryptionException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.getSecurityContext().prependSecurityElement(this.factory.toElement((EncryptedKey)this.getEncryptedTypeHolder()));
    }

    protected void doFinalDecryption() throws WSSecurityException {
        this.wsKeyInfo.doFinal();
        EncryptedTypeObject[] refs = this.getReferences();
        if (refs.length == 0) {
            cat.error("EncryptedKey without reference list");
            throw WSSecurityException.INVALID_SECURITY;
        }
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getType() == 2 || refs[i].getType() == 4) {
                refs[i].doFinal();
            }
            ++i;
        }
        this.getSecurityContext().addReceivedEncryptedKeyConf(this.getReceivedConf());
    }

    protected EncryptedKeyConf getReceivedConf() {
        KeyInfoConf kiconf;
        EncryptedTypeObject[] refs;
        EncryptedKeyConf conf = this.getSecurityContext().getMessageConf().newEncryptedKey();
        conf.setWsuId(this.getWsuId());
        if (conf.getWsuId() == null) {
            conf.setWsuId(WSSecurityHelper.getWsuIdFromElement(this.encryptedKeyElement));
        }
        EncryptionMethod em = this.getEncryptionMethod();
        conf.setEncryptionMethodAlgorithm(em.getAlgorithmURI());
        EncryptionMethodParams emParams = em.getParams();
        if (emParams instanceof OAEPParams) {
            String digestMethod = ((OAEPParams)emParams).getDigestMethodURI();
            byte[] paramBytes = ((OAEPParams)emParams).getOAEPParamBytes();
            PropertyConf pDigest = null;
            if (digestMethod != null) {
                pDigest = conf.newEncryptionMethodProperty();
                pDigest.setPropertyName("OAEPDigest");
                pDigest.setPropertyValue(digestMethod);
            }
            PropertyConf pPbytes = null;
            if (paramBytes != null && paramBytes.length > 0) {
                pPbytes = conf.newEncryptionMethodProperty();
                pPbytes.setPropertyName("OAEPParams");
                pPbytes.setPropertyValue(Base64.encode(paramBytes));
            }
            if (pDigest != null && pPbytes != null) {
                conf.setEncryptionMethodProperties(new PropertyConf[]{pDigest, pPbytes});
            } else if (pDigest != null) {
                conf.setEncryptionMethodProperties(new PropertyConf[]{pDigest});
            } else if (pPbytes != null) {
                conf.setEncryptionMethodProperties(new PropertyConf[]{pPbytes});
            }
        }
        if ((refs = this.getReferences()) != null && refs.length > 0) {
            EncryptionReferenceConf[] encRefs = new EncryptionReferenceConf[refs.length];
            int i = 0;
            while (i < refs.length) {
                encRefs[i] = conf.newReference();
                encRefs[i].setRefUri("#" + refs[i].getWsuId());
                ++i;
            }
            conf.setReferences(encRefs);
        }
        if (this.wsKeyInfo.setupKeyInfoConf(kiconf = conf.newKeyInfo())) {
            conf.setKeyInfo(kiconf);
        }
        return conf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

