/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws;

import com.idoox.debug.Category;
import com.idoox.security.util.Base64;
import com.idoox.security.util.CertUtil;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.InternalWSSecurityContext;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.idoox.security.jaas.NamePasswordCredential;
import org.idoox.security.jaas.PrivateKeyCertsCredential;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.security.ws.conf.WSSEConf;
import org.w3c.dom.Element;

public class X509SecurityToken
extends SecurityTokenSPI {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.X509SecurityToken");
    public static final String TOKEN_PROFILE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0";
    public static final MessageDigest messageDigest;
    private PrivateKey privateKey;
    private X509Certificate x509Certificate = null;
    private static final String KEY_IDENTIFIER_VALUE_TYPE = "X509SubjectKeyIdentifier";
    static /* synthetic */ Class class$org$idoox$security$jaas$PrivateKeyCertsCredential;
    static /* synthetic */ Class class$org$idoox$security$jaas$NamePasswordCredential;

    public X509SecurityToken(SecurityContext securityContext, X509Certificate x509Certificate, PrivateKey privateKey, boolean isExternal) throws XMLSecurityException {
        super(securityContext, isExternal);
        this.privateKey = privateKey;
        this.setX509Certificate(x509Certificate);
    }

    public X509SecurityToken(Element element, SecurityContext securityContext) throws XMLSecurityException {
        super(element, securityContext);
    }

    public byte[] getKeyIdentifier() throws WSSecurityException {
        X509Certificate cert = this.getX509Certificate();
        return X509SecurityToken.getKeyIdentifier(cert, this.getWsuId());
    }

    public static byte[] getKeyIdentifier(X509Certificate cert, String wsuId) {
        if (cert == null) {
            log.error("cannot get certificate for BinarySecurityToken id=" + wsuId);
            throw WSSecurityException.FAILED_AUTHENTICATION;
        }
        byte[] retVal = X509SecurityToken.getSKIExtensionIOP(cert);
        if (retVal != null) {
            return retVal;
        }
        PublicKey publicKey = cert.getPublicKey();
        MessageDigest messageDigest = X509SecurityToken.messageDigest;
        synchronized (messageDigest) {
            X509SecurityToken.messageDigest.reset();
            byte[] byArray = X509SecurityToken.messageDigest.digest(publicKey.getEncoded());
            return byArray;
        }
    }

    public static byte[] getSKIExtensionIOP(X509Certificate cert) {
        byte[] ext = cert.getExtensionValue("2.5.29.14");
        if (ext != null) {
            byte[] ski = new byte[ext.length - 4];
            System.arraycopy(ext, 4, ski, 0, ski.length);
            return ski;
        }
        return null;
    }

    public Key getEncryptingKey() throws WSSecurityException {
        return this.getPublicKey();
    }

    public Key getDecryptingKey() throws WSSecurityException {
        return this.getPrivateKey();
    }

    public Key getSigningKey() throws WSSecurityException {
        return this.getPrivateKey();
    }

    public Key getAuthenticatingKey() throws WSSecurityException {
        return this.getPublicKey();
    }

    public void setValueType(String valueType) {
        this.addAnyAttribute("ValueType", valueType);
    }

    public String getValueType() {
        return WSSecurityHelper.getAttributeNS((String)null, "ValueType", this.getElement());
    }

    public String getKeyIdentifierValueType() {
        String wsseNamespace = this.getSecurityContext().getWsseNamespace();
        if (!WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace)) {
            return super.getKeyIdentifierValueType();
        }
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    }

    public void setEncodingType(String encodingType) {
        this.addAnyAttribute("EncodingType", encodingType);
    }

    public String getEncodingType() {
        return WSSecurityHelper.getAttributeNS((String)null, "EncodingType", this.getElement());
    }

    public void setX509Certificate(X509Certificate cert) throws XMLSecurityException {
        this.x509Certificate = cert;
        try {
            this.addBase64Text(cert.getEncoded());
            String valueType = null;
            String encodingType = null;
            String wsseNamespace = this.getSecurityContext().getWsseNamespace();
            if (!WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace)) {
                String wssePrefix = ElementProxy.getDefaultPrefix(this.getBaseNamespace());
                wssePrefix = wssePrefix == null ? "" : wssePrefix + ":";
                valueType = wssePrefix + "X509v3";
                encodingType = wssePrefix + "Base64Binary";
            } else {
                valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
                encodingType = WSSecurityHelper.fromNs2SpecLocation(wsseNamespace) + "#" + "Base64Binary";
            }
            this.setValueType(valueType);
            this.setEncodingType(encodingType);
        }
        catch (CertificateEncodingException e) {
            throw new XMLSecurityException(e);
        }
    }

    protected PublicKey getPublicKey() throws WSSecurityException {
        return this.getX509Certificate().getPublicKey();
    }

    protected PrivateKey getPrivateKey() throws WSSecurityException {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        X509Certificate cert = this.getX509Certificate();
        PrivateKeyCertsCredential[] pkcCreds = (PrivateKeyCertsCredential[])WSSecurityHelper.getCurrentCredentials(class$org$idoox$security$jaas$PrivateKeyCertsCredential == null ? (class$org$idoox$security$jaas$PrivateKeyCertsCredential = X509SecurityToken.class$("org.idoox.security.jaas.PrivateKeyCertsCredential")) : class$org$idoox$security$jaas$PrivateKeyCertsCredential);
        int i = 0;
        while (i < pkcCreds.length) {
            PrivateKey key;
            if (cert.equals(pkcCreds[i].getCertificate()) && (key = pkcCreds[i].getPrivateKey()) != null) {
                return key;
            }
            ++i;
        }
        NamePasswordCredential[] npCreds = (NamePasswordCredential[])WSSecurityHelper.getCurrentCredentials(class$org$idoox$security$jaas$NamePasswordCredential == null ? (class$org$idoox$security$jaas$NamePasswordCredential = X509SecurityToken.class$("org.idoox.security.jaas.NamePasswordCredential")) : class$org$idoox$security$jaas$NamePasswordCredential);
        i = 0;
        while (i < npCreds.length) {
            PrivateKey key;
            PrivateKeyCertsCredential pkcCred = WSSecurityHelper.createPrivateKeyCertsCredentials(npCreds[i].getName(), npCreds[i].getPassword(), (InternalWSSecurityContext)this.getSecurityContext());
            if (cert.equals(pkcCred.getCertificate()) && (key = pkcCred.getPrivateKey()) != null) {
                return key;
            }
            ++i;
        }
        log.error("Cannot find any NamePasswordCredential or PrivateKeyCertsCredentials identifying private key");
        throw WSSecurityException.FAILED_AUTHENTICATION;
    }

    public X509Certificate getX509Certificate() throws WSSecurityException {
        if (this.x509Certificate != null) {
            return this.x509Certificate;
        }
        Element dummy = this.getElement();
        String encodingType = null;
        String valueType = null;
        String wsseNamespace = this.getSecurityContext().getWsseNamespace();
        if (!WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace)) {
            String prefix = dummy.getPrefix();
            prefix = prefix != null ? prefix + ":" : "";
            if (prefix == null || ":".equals(prefix)) {
                prefix = "";
            }
            encodingType = prefix + "Base64Binary";
            valueType = prefix + "X509v3";
        } else {
            valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
            encodingType = WSSecurityHelper.fromNs2SpecLocation(wsseNamespace) + "#" + "Base64Binary";
        }
        if (!(WSSecurity.KNOWN_SECURITY_URI_LIST.contains(dummy.getNamespaceURI()) && encodingType.equals(dummy.getAttributeNS(null, "EncodingType")) && valueType.equals(dummy.getAttributeNS(null, "ValueType")))) {
            log.error("unsupported combination of ValueType and EncodingType");
            throw WSSecurityException.INVALID_SECURITY_TOKEN;
        }
        try {
            X509Certificate cert;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.x509Certificate = cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.getBytesFromTextChild()));
            return cert;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.FAILED_AUTHENTICATION;
        }
    }

    public void doFinal(int mode) {
        if (mode == 1) {
            String wssePrefix = ElementProxy.getDefaultPrefix(this.getBaseNamespace());
            wssePrefix = wssePrefix == null ? "" : wssePrefix + ":";
            String valueType = null;
            valueType = !WSSecurity.RC_SECURITY_URI_LIST.contains(this.getSecurityContext().getWsseNamespace()) ? wssePrefix + "X509v3" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
            if (valueType.equals(this.getValueType())) {
                X509Certificate x509Certificate;
                WSSEConf securityConf = WSSecurityHelper.getSecurityConfiguration();
                Boolean checkDisabled = Boolean.FALSE;
                if (securityConf != null && (checkDisabled = securityConf.getDisableCertCheck()) == null) {
                    checkDisabled = Boolean.FALSE;
                }
                if (!Boolean.TRUE.equals(checkDisabled) && !CertUtil.IsCertTrusted((X509Certificate)(x509Certificate = this.getX509Certificate()))) {
                    log.error("The received certificate is not trusted " + x509Certificate.getSubjectUniqueID());
                    throw WSSecurityException.INVALID_SECURITY_TOKEN;
                }
            }
        }
    }

    public SecurityTokenConf getReceivedConf() {
        SecurityTokenConf tokenConf = this.getSecurityContext().getMessageConf().newSecurityToken();
        X509Certificate x509Certificate = this.getX509Certificate();
        if (x509Certificate != null) {
            PropertyConf propertyConf = tokenConf.newProperty();
            try {
                propertyConf.setPropertyName("base64Certificate");
                propertyConf.setPropertyValue(new String(Base64.encode((byte[])x509Certificate.getEncoded()), "UTF-8"));
                tokenConf.setProperties(new PropertyConf[]{propertyConf});
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return tokenConf;
    }

    public String getType() {
        return "X509v3";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("cannot get instance of SHA1 message digest " + e.toString());
        }
    }
}

