/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.utils;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdResolver {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$utils$IdResolver == null ? (class$com$systinet$wasp$security$secext$utils$IdResolver = IdResolver.class$("com.systinet.wasp.security.secext.utils.IdResolver")) : class$com$systinet$wasp$security$secext$utils$IdResolver).getName());
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$utils$IdResolver;

    private IdResolver() {
    }

    public static void registerElementById(Element element, String idValue) {
        Document doc = element.getOwnerDocument();
        ((DocumentImpl)doc).putIdentifier(idValue, element);
    }

    public static void registerElementById(Element element, Attr id) {
        IdResolver.registerElementById(element, id.getNodeValue());
    }

    public static Element getElementById(Document doc, String id) {
        Element result = null;
        result = IdResolver.getElementByIdType(doc, id);
        if (result != null) {
            return result;
        }
        result = IdResolver.getElementByIdInDSNamespace(doc, id);
        if (result != null) {
            IdResolver.registerElementById(result, id);
            return result;
        }
        result = IdResolver.getElementByIdInXENCNamespace(doc, id);
        if (result != null) {
            IdResolver.registerElementById(result, id);
            return result;
        }
        result = IdResolver.getElementByIdInSOAPSignatureNamespace(doc, id);
        if (result != null) {
            IdResolver.registerElementById(result, id);
            return result;
        }
        result = IdResolver.getElementByIdInXKMSNamespace(doc, id);
        if (result != null) {
            IdResolver.registerElementById(result, id);
            return result;
        }
        result = IdResolver.getElementByIdUnsafeMatchByIdName(doc, id);
        if (result != null) {
            cat.warn("I could find an Element using the totally stupid and insecure Id/ID/id searcher method: " + result.getTagName());
            return result;
        }
        return null;
    }

    private static Element getElementByIdType(Document doc, String id) {
        return doc.getElementById(id);
    }

    private static Element getElementByIdInDSNamespace(Document doc, String id) {
        try {
            Element nscontext = XMLUtils.createDSctx(doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element element = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//ds:*[@Id='" + id + "']"), (Node)nscontext);
            return element;
        }
        catch (TransformerException ex) {
            cat.error("empty", (Throwable)ex);
            return null;
        }
    }

    private static Element getElementByIdInXENCNamespace(Document doc, String id) {
        try {
            Element nscontext = XMLUtils.createDSctx(doc, "xenc", "http://www.w3.org/2001/04/xmlenc#");
            Element element = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//xenc:*[@Id='" + id + "']"), (Node)nscontext);
            return element;
        }
        catch (TransformerException ex) {
            cat.error("empty", (Throwable)ex);
            return null;
        }
    }

    private static Element getElementByIdInSOAPSignatureNamespace(Document doc, String id) {
        try {
            Element nscontext = XMLUtils.createDSctx(doc, "SOAP-SEC", "http://schemas.xmlsoap.org/soap/security/2000-12");
            Element element = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//*[@SOAP-SEC:id='" + id + "']"), (Node)nscontext);
            return element;
        }
        catch (TransformerException ex) {
            cat.error("empty", (Throwable)ex);
            return null;
        }
    }

    private static Element getElementByIdInXKMSNamespace(Document doc, String id) {
        try {
            Element nscontext = XMLUtils.createDSctx(doc, "xkms", "http://www.w3.org/2002/03/xkms#");
            String[] attrs = new String[]{"ID", "OriginalRequestID", "RequestID", "ResponseID"};
            int i = 0;
            while (i < attrs.length) {
                String attr = attrs[i];
                Element element = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//xkms:*[@" + attr + "='" + id + "']"), (Node)nscontext);
                if (element != null) {
                    return element;
                }
                ++i;
            }
            return null;
        }
        catch (TransformerException ex) {
            cat.error("empty", (Throwable)ex);
            return null;
        }
    }

    private static Element getElementByIdUnsafeMatchByIdName(Document doc, String id) {
        try {
            Element element_Id = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//*[@Id='" + id + "']"));
            if (element_Id != null) {
                return element_Id;
            }
            Element element_ID = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//*[@ID='" + id + "']"));
            if (element_ID != null) {
                return element_ID;
            }
            Element element_id = (Element)XPathAPI.selectSingleNode((Node)doc, (String)("//*[@id='" + id + "']"));
            if (element_id != null) {
                return element_id;
            }
        }
        catch (TransformerException ex) {
            cat.error("empty", (Throwable)ex);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

