/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.params;

import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.transforms.TransformParam;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathFilterCHGPContainer
extends ElementProxy
implements TransformParam {
    private static final String _TAG_INCLUDE_BUT_SEARCH = "IncludeButSearch";
    private static final String _TAG_EXCLUDE_BUT_SEARCH = "ExcludeButSearch";
    private static final String _TAG_EXCLUDE = "Exclude";
    public static final String _TAG_XPATHCHGP = "XPathAlternative";
    public static final String _ATT_INCLUDESLASH = "IncludeSlashPolicy";
    public static final boolean IncludeSlash = true;
    public static final boolean ExcludeSlash = false;

    private XPathFilterCHGPContainer() {
    }

    private XPathFilterCHGPContainer(Document doc, boolean includeSlashPolicy, String includeButSearch, String excludeButSearch, String exclude) {
        super(doc);
        if (includeSlashPolicy) {
            this._constructionElement.setAttributeNS(null, _ATT_INCLUDESLASH, "true");
        } else {
            this._constructionElement.setAttributeNS(null, _ATT_INCLUDESLASH, "false");
        }
        if (includeButSearch != null && includeButSearch.trim().length() > 0) {
            Element includeButSearchElem = ElementProxy.createElementForFamily(doc, this.getBaseNamespace(), _TAG_INCLUDE_BUT_SEARCH);
            includeButSearchElem.appendChild(this._doc.createTextNode(XPathFilterCHGPContainer.indentXPathText(includeButSearch)));
            this._constructionElement.appendChild(doc.createTextNode("\n"));
            this._constructionElement.appendChild(includeButSearchElem);
        }
        if (excludeButSearch != null && excludeButSearch.trim().length() > 0) {
            Element excludeButSearchElem = ElementProxy.createElementForFamily(doc, this.getBaseNamespace(), _TAG_EXCLUDE_BUT_SEARCH);
            excludeButSearchElem.appendChild(this._doc.createTextNode(XPathFilterCHGPContainer.indentXPathText(excludeButSearch)));
            this._constructionElement.appendChild(doc.createTextNode("\n"));
            this._constructionElement.appendChild(excludeButSearchElem);
        }
        if (exclude != null && exclude.trim().length() > 0) {
            Element excludeElem = ElementProxy.createElementForFamily(doc, this.getBaseNamespace(), _TAG_EXCLUDE);
            excludeElem.appendChild(this._doc.createTextNode(XPathFilterCHGPContainer.indentXPathText(exclude)));
            this._constructionElement.appendChild(doc.createTextNode("\n"));
            this._constructionElement.appendChild(excludeElem);
        }
        this._constructionElement.appendChild(doc.createTextNode("\n"));
    }

    static String indentXPathText(String xp) {
        if (xp.length() > 2 && !Character.isWhitespace(xp.charAt(0))) {
            return "\n" + xp + "\n";
        }
        return xp;
    }

    private XPathFilterCHGPContainer(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public static XPathFilterCHGPContainer getInstance(Document doc, boolean includeSlashPolicy, String includeButSearch, String excludeButSearch, String exclude) {
        return new XPathFilterCHGPContainer(doc, includeSlashPolicy, includeButSearch, excludeButSearch, exclude);
    }

    public static XPathFilterCHGPContainer getInstance(Element element, String BaseURI) throws XMLSecurityException {
        return new XPathFilterCHGPContainer(element, BaseURI);
    }

    private String getXStr(String type) {
        if (this.length(this.getBaseNamespace(), type) != 1) {
            return "";
        }
        Element xElem = this.getChildElementLocalName(0, this.getBaseNamespace(), type);
        return XMLUtils.getFullTextChildrenFromElement(xElem);
    }

    public String getIncludeButSearch() {
        return this.getXStr(_TAG_INCLUDE_BUT_SEARCH);
    }

    public String getExcludeButSearch() {
        return this.getXStr(_TAG_EXCLUDE_BUT_SEARCH);
    }

    public String getExclude() {
        return this.getXStr(_TAG_EXCLUDE);
    }

    public boolean getIncludeSlashPolicy() {
        return this._constructionElement.getAttributeNS(null, _ATT_INCLUDESLASH).equals("true");
    }

    private Node getHereContextNode(String type) {
        if (this.length(this.getBaseNamespace(), type) != 1) {
            return null;
        }
        Element xElem = this.getChildElementLocalName(0, this.getBaseNamespace(), type);
        NodeList children = xElem.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            if (children.item(i).getNodeType() == 3) {
                return children.item(i);
            }
            ++i;
        }
        return null;
    }

    public Node getHereContextNodeIncludeButSearch() {
        return this.getHereContextNode(_TAG_INCLUDE_BUT_SEARCH);
    }

    public Node getHereContextNodeExcludeButSearch() {
        return this.getHereContextNode(_TAG_EXCLUDE_BUT_SEARCH);
    }

    public Node getHereContextNodeExclude() {
        return this.getHereContextNode(_TAG_EXCLUDE);
    }

    public final String getBaseLocalName() {
        return _TAG_XPATHCHGP;
    }

    public final String getBaseNamespace() {
        return "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    }
}

