/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.params;

import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.transforms.TransformParam;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InclusiveNamespaces
extends ElementProxy
implements TransformParam {
    public static final String _TAG_EC_INCLUSIVENAMESPACES = "InclusiveNamespaces";
    public static final String _ATT_EC_PREFIXLIST = "PrefixList";
    public static final String ExclusiveCanonicalizationNamespace = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public InclusiveNamespaces(Document doc, String prefixList) {
        this(doc, InclusiveNamespaces.prefixStr2Set(prefixList));
    }

    public InclusiveNamespaces(Document doc, Set prefixes) {
        super(doc);
        StringBuffer sb = new StringBuffer();
        Vector prefixList = new Vector(prefixes);
        Collections.sort(prefixList);
        Iterator it = prefixList.iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            if (prefix.equals("xmlns")) {
                sb.append("#default ");
                continue;
            }
            sb.append(prefix.substring("xmlns:".length()) + " ");
        }
        this._constructionElement.setAttributeNS(null, _ATT_EC_PREFIXLIST, sb.toString().trim());
    }

    public String getInclusiveNamespaces() {
        return this._constructionElement.getAttributeNS(null, _ATT_EC_PREFIXLIST);
    }

    public InclusiveNamespaces(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public static Set prefixStr2Set(String inclusiveNamespaces) {
        HashSet<String> prefixes = new HashSet<String>();
        if (inclusiveNamespaces == null || inclusiveNamespaces.length() == 0) {
            return prefixes;
        }
        StringTokenizer st = new StringTokenizer(inclusiveNamespaces, " \t\r\n");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            if (prefix.equals("#default")) {
                prefixes.add("xmlns");
                continue;
            }
            prefixes.add("xmlns:" + prefix);
        }
        return prefixes;
    }

    public String getBaseNamespace() {
        return ExclusiveCanonicalizationNamespace;
    }

    public String getBaseLocalName() {
        return _TAG_EC_INCLUSIVENAMESPACES;
    }
}

