/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.implementations;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.c14n.implementations.Canonicalizer20010315ExclOmitComments;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import com.systinet.wasp.security.secext.transforms.params.InclusiveNamespaces;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TransformC14NExclusive
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws CanonicalizationException, InvalidCanonicalizerException {
        try {
            InclusiveNamespaces inclusiveNamespaces = null;
            if (this._transformObject.length(implementedTransformURI, "InclusiveNamespaces") == 1) {
                Element inclusiveElement = this._transformObject.getChildElementLocalName(0, implementedTransformURI, "InclusiveNamespaces");
                inclusiveNamespaces = new InclusiveNamespaces(inclusiveElement, this._transformObject.getBaseURI());
            }
            Canonicalizer20010315ExclOmitComments c14n = new Canonicalizer20010315ExclOmitComments();
            if (input.isOctetStream()) {
                return new XMLSignatureInput(c14n.engineCanonicalize(input.getBytes()));
            }
            if (inclusiveNamespaces == null) {
                return new XMLSignatureInput(c14n.engineCanonicalizeXPathNodeSet(input.getNodeSet()));
            }
            return new XMLSignatureInput(c14n.engineCanonicalizeXPathNodeSet(input.getNodeSet(), inclusiveNamespaces.getInclusiveNamespaces()));
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }
}

