/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.signature;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.SignatureAlgorithm;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.KeyInfo;
import com.systinet.wasp.security.secext.keys.content.X509Data;
import com.systinet.wasp.security.secext.signature.ObjectContainer;
import com.systinet.wasp.security.secext.signature.SignedInfo;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.transforms.Transforms;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.I18n;
import com.systinet.wasp.security.secext.utils.IdResolver;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolver;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolverSpi;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XMLSignature
extends SignatureElementProxy {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$signature$XMLSignature == null ? (class$com$systinet$wasp$security$secext$signature$XMLSignature = XMLSignature.class$("com.systinet.wasp.security.secext.signature.XMLSignature")) : class$com$systinet$wasp$security$secext$signature$XMLSignature).getName());
    public static final String ALGO_ID_MAC_HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_NOT_RECOMMENDED_RSA_MD5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
    public static final String ALGO_ID_SIGNATURE_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_MAC_HMAC_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
    public static final String ALGO_ID_MAC_HMAC_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
    public static final String ALGO_ID_MAC_HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String ALGO_ID_MAC_HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    public static final String ALGO_ID_MAC_HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    private SignedInfo _signedInfo = null;
    private KeyInfo _keyInfo = null;
    private boolean _followManifestsDuringValidation = false;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$signature$XMLSignature;

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI) throws XMLSecurityException {
        this(doc, BaseURI, SignatureMethodURI, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI, int HMACOutputLength) throws XMLSecurityException {
        this(doc, BaseURI, SignatureMethodURI, HMACOutputLength, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI, String CanonicalizationMethodURI) throws XMLSecurityException {
        this(doc, BaseURI, SignatureMethodURI, 0, CanonicalizationMethodURI);
    }

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI, int HMACOutputLength, String CanonicalizationMethodURI) throws XMLSecurityException {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = BaseURI;
        this._signedInfo = new SignedInfo(this._doc, SignatureMethodURI, HMACOutputLength, CanonicalizationMethodURI);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        Element signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Document doc, String BaseURI, Element SignatureMethodElem, Element CanonicalizationMethodElem) throws XMLSecurityException {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = BaseURI;
        this._signedInfo = new SignedInfo(this._doc, SignatureMethodElem, CanonicalizationMethodElem);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        Element signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Element element, String BaseURI) throws XMLSignatureException, XMLSecurityException, IOException {
        super(element, BaseURI);
        Element signedInfoElem = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
        if (signedInfoElem == null) {
            Object[] exArgs = new Object[]{"SignedInfo", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", exArgs);
        }
        this._signedInfo = new SignedInfo(signedInfoElem, BaseURI);
        Element signatureValueElement = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        if (signatureValueElement == null) {
            Object[] exArgs = new Object[]{"SignatureValue", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", exArgs);
        }
        Element keyInfoElem = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (keyInfoElem != null) {
            this._keyInfo = new KeyInfo(keyInfoElem, BaseURI);
        }
    }

    public void setId(String Id) {
        if (this._state == 0 && Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public SignedInfo getSignedInfo() {
        return this._signedInfo;
    }

    public byte[] getSignatureValue() throws XMLSignatureException {
        try {
            Element signatureValueElem = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            byte[] signatureValue = Base64.decode(signatureValueElem);
            return signatureValue;
        }
        catch (Base64DecodingException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    private void setSignatureValueElement(byte[] bytes) throws XMLSignatureException {
        if (this._state == 0) {
            Element signatureValueElem = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            NodeList children = signatureValueElem.getChildNodes();
            while (signatureValueElem.hasChildNodes()) {
                signatureValueElem.removeChild(signatureValueElem.getFirstChild());
            }
            String base64codedValue = Base64.encode(bytes);
            if (base64codedValue.length() > 76) {
                base64codedValue = "\n" + base64codedValue + "\n";
            }
            Text t = this._doc.createTextNode(base64codedValue);
            signatureValueElem.appendChild(t);
        }
    }

    public KeyInfo getKeyInfo() {
        if (this._state == 0 && this._keyInfo == null) {
            this._keyInfo = new KeyInfo(this._doc);
            Element keyInfoElement = this._keyInfo.getElement();
            try {
                Element nscontext = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
                Element firstObject = (Element)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)"./ds:Object[1]", (Node)nscontext);
                if (firstObject != null) {
                    this._constructionElement.insertBefore(keyInfoElement, firstObject);
                    this._constructionElement.insertBefore(this._doc.createTextNode("\n"), firstObject);
                } else {
                    this._constructionElement.appendChild(keyInfoElement);
                    XMLUtils.addReturnToElement(this._constructionElement);
                }
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
            }
        }
        return this._keyInfo;
    }

    public void appendObject(ObjectContainer object) throws XMLSignatureException {
        try {
            if (this._state != 0) {
                throw new XMLSignatureException("signature.operationOnlyBeforeSign");
            }
            this._constructionElement.appendChild(object.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public ObjectContainer getObjectItem(int i) {
        Element objElem = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "Object");
        try {
            return new ObjectContainer(objElem, this._baseURI);
        }
        catch (XMLSecurityException ex) {
            return null;
        }
    }

    public int getObjectLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Object");
    }

    public void sign(Key signingKey) throws XMLSignatureException {
        if (signingKey instanceof PublicKey) {
            throw new IllegalArgumentException(I18n.translate("algorithms.operationOnlyVerification"));
        }
        try {
            if (this._state == 0) {
                Element signatureMethodElement = this._signedInfo.getSignatureMethodElement();
                SignatureAlgorithm sa = new SignatureAlgorithm(signatureMethodElement, this.getBaseURI());
                sa.initSign(signingKey);
                SignedInfo si = this.getSignedInfo();
                si.generateDigestValues();
                byte[] signedInfoOctets = si.getCanonicalizedOctetStream();
                sa.update(signedInfoOctets);
                byte[] jcebytes = sa.sign();
                this.setSignatureValueElement(jcebytes);
            }
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public void addResourceResolver(ResourceResolver resolver) {
        this.getSignedInfo().addResourceResolver(resolver);
    }

    public void addResourceResolver(ResourceResolverSpi resolver) {
        this.getSignedInfo().addResourceResolver(resolver);
    }

    public boolean checkSignatureValue(X509Certificate cert) throws XMLSignatureException {
        if (cert != null) {
            return this.checkSignatureValue(cert.getPublicKey());
        }
        Object[] exArgs = new Object[]{"Didn't get a certificate"};
        throw new XMLSignatureException("empty", exArgs);
    }

    public boolean checkSignatureValue(Key pk) throws XMLSignatureException {
        if (pk == null) {
            Object[] exArgs = new Object[]{"Didn't get a key"};
            throw new XMLSignatureException("empty", exArgs);
        }
        try {
            if (!this.getSignedInfo().verify(this._followManifestsDuringValidation)) {
                return false;
            }
            SignatureAlgorithm sa = new SignatureAlgorithm(this.getSignedInfo().getSignatureMethodElement(), this.getBaseURI());
            sa.initVerify(pk);
            byte[] inputBytes = this._signedInfo.getCanonicalizedOctetStream();
            sa.update(inputBytes);
            byte[] sigBytes = this.getSignatureValue();
            boolean verify = sa.verify(sigBytes);
            return verify;
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public void addDocument(String referenceURI, Transforms trans, String digestURI, String ReferenceId, String ReferenceType) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, trans, digestURI, ReferenceId, ReferenceType);
    }

    public void addDocument(String referenceURI, Transforms trans, String digestURI) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, trans, digestURI, null, null);
    }

    public void addDocument(String referenceURI, Transforms trans) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, trans, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addDocument(String referenceURI) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, null, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addKeyInfo(X509Certificate cert) throws XMLSecurityException {
        X509Data x509data = new X509Data(this._doc);
        x509data.addCertificate(cert);
        this.getKeyInfo().add(x509data);
    }

    public void addKeyInfo(PublicKey pk) {
        this.getKeyInfo().add(pk);
    }

    public SecretKey createSecretKey(byte[] secretKeyBytes) throws XMLSecurityException {
        return this.getSignedInfo().createSecretKey(secretKeyBytes);
    }

    public void setFollowNestedManifests(boolean followManifests) {
        this._followManifestsDuringValidation = followManifests;
    }

    public String getBaseLocalName() {
        return "Signature";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

