/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.signature;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.MessageDigestAlgorithm;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.Manifest;
import com.systinet.wasp.security.secext.signature.ReferenceNotInitializedException;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.InvalidTransformException;
import com.systinet.wasp.security.secext.transforms.Transform;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.transforms.Transforms;
import com.systinet.wasp.security.secext.transforms.params.InclusiveNamespaces;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.IdResolver;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolver;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolverException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    public static boolean CacheSignedNodes = false;
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$signature$Reference == null ? (class$com$systinet$wasp$security$secext$signature$Reference = Reference.class$("com.systinet.wasp.security.secext.signature.Reference")) : class$com$systinet$wasp$security$secext$signature$Reference).getName());
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    Manifest _manifest = null;
    XMLSignatureInput _transformsInput;
    XMLSignatureInput _transformsOutput;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$signature$Reference;

    protected Reference(Document doc, String BaseURI, String ReferenceURI, Manifest manifest, Transforms transforms, String messageDigestAlgorithm) throws XMLSignatureException {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = BaseURI;
        this._manifest = manifest;
        this.setURI(ReferenceURI);
        Element nscontext = XMLUtils.createDSctx(this._doc, "ds");
        if (transforms != null) {
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        MessageDigestAlgorithm mda = MessageDigestAlgorithm.getInstance(this._doc, messageDigestAlgorithm);
        this._constructionElement.appendChild(mda.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        Element digestValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "DigestValue");
        this._constructionElement.appendChild(digestValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    protected Reference(Document doc, String BaseURI, String ReferenceURI, Manifest manifest, String messageDigestAlgorithm) throws XMLSignatureException {
        this(doc, BaseURI, ReferenceURI, manifest, null, messageDigestAlgorithm);
    }

    protected Reference(Document doc, String BaseURI, String ReferenceURI, Manifest manifest, Transforms transforms) throws XMLSignatureException {
        this(doc, BaseURI, ReferenceURI, manifest, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    protected Reference(Document doc, String BaseURI, String ReferenceURI, Manifest manifest) throws XMLSignatureException {
        this(doc, BaseURI, ReferenceURI, manifest, null, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    protected Reference(Element element, String BaseURI, Manifest manifest) throws XMLSecurityException {
        super(element, BaseURI);
        this._manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        Element digestMethodElem = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (digestMethodElem == null) {
            return null;
        }
        String uri = digestMethodElem.getAttributeNS(null, "Algorithm");
        return MessageDigestAlgorithm.getInstance(this._doc, uri);
    }

    public void setURI(String URI2) {
        if (this._state == 0 && URI2 != null) {
            this._constructionElement.setAttributeNS(null, "URI", URI2);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String Id) {
        if (this._state == 0 && Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String Type2) {
        if (this._state == 0 && Type2 != null) {
            this._constructionElement.setAttributeNS(null, "Type", Type2);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean typeIsReferenceToObject() {
        return this.getType() != null && this.getType().equals(OBJECT_URI);
    }

    public boolean typeIsReferenceToManifest() {
        return this.getType() != null && this.getType().equals(MANIFEST_URI);
    }

    private void setDigestValueElement(byte[] digestValue) throws XMLSignatureException {
        if (this._state == 0) {
            Element digestValueElement = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestValue");
            NodeList children = digestValueElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                digestValueElement.removeChild(children.item(i));
                ++i;
            }
            String base64codedValue = Base64.encode(digestValue);
            Text t = this._doc.createTextNode(base64codedValue);
            digestValueElement.appendChild(t);
        }
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            byte[] calculatedBytes = this.calculateDigest();
            this.setDigestValueElement(calculatedBytes);
        }
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr URIAttr = this._constructionElement.getAttributeNodeNS(null, "URI");
            String URI2 = URIAttr == null ? null : URIAttr.getNodeValue();
            ResourceResolver resolver = ResourceResolver.getInstance(URIAttr, this._baseURI, this._manifest._perManifestResolvers);
            if (resolver == null) {
                Object[] exArgs = new Object[]{URI2};
                throw new ReferenceNotInitializedException("signature.Verification.Reference.NoInput", exArgs);
            }
            resolver.addProperties(this._manifest._resolverProperties);
            XMLSignatureInput input = resolver.resolve(URIAttr, this._baseURI);
            this._transformsInput = new XMLSignatureInput(input.getBytes());
            this._transformsInput.setSourceURI(input.getSourceURI());
            return input;
        }
        catch (IOException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (ResourceResolverException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    public XMLSignatureInput getTransformsInput() {
        return this._transformsInput;
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput input) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput output = null;
            if (transforms != null) {
                output = transforms.performTransforms(input);
                this._transformsOutput = new XMLSignatureInput(output.getBytes());
                this._transformsOutput.setSourceURI(output.getSourceURI());
            } else {
                output = input;
                this._transformsOutput = this._transformsInput;
            }
            return output;
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (ResourceResolverException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (TransformationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput input = this.getContentsBeforeTransformation();
        return this.getContentsAfterTransformation(input);
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            String URI2;
            XMLSignatureInput input;
            XMLSignatureInput output = input = this.getContentsBeforeTransformation();
            Transforms transforms = this.getTransforms();
            Transform c14nTransform = null;
            if (transforms != null) {
                int i = 0;
                while (i < transforms.getLength()) {
                    Transform t = transforms.item(i);
                    String URI3 = t.getURI();
                    if (URI3.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || URI3.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || URI3.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || URI3.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) {
                        c14nTransform = t;
                        break;
                    }
                    output = t.performTransform(output);
                    ++i;
                }
                output.setSourceURI(input.getSourceURI());
            }
            if (c14nTransform != null && ((URI2 = c14nTransform.getURI()).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || URI2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) && c14nTransform.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                Element inE = c14nTransform.getChildElementLocalName(0, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
                InclusiveNamespaces in = new InclusiveNamespaces(inE, this.getBaseURI());
                String ins = in.getInclusiveNamespaces();
            }
            return output;
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (ResourceResolverException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (TransformationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            XMLSignatureInput nodes = this.getNodesetBeforeFirstCanonicalization();
            Set inclusiveNamespaces = new HashSet();
            Transforms transforms = this.getTransforms();
            Transform c14nTransform = null;
            if (transforms != null) {
                int i = 0;
                while (i < transforms.getLength()) {
                    Transform t = transforms.item(i);
                    String URI2 = t.getURI();
                    if (URI2.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || URI2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
                        c14nTransform = t;
                        break;
                    }
                    ++i;
                }
            }
            if (c14nTransform != null) {
                String URI3 = c14nTransform.getURI();
                if (c14nTransform.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                    InclusiveNamespaces in = new InclusiveNamespaces(c14nTransform.getChildElementLocalName(0, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces"), this.getBaseURI());
                    inclusiveNamespaces = InclusiveNamespaces.prefixStr2Set(in.getInclusiveNamespaces());
                }
            }
            return nodes.getHTMLRepresentation(inclusiveNamespaces);
        }
        catch (TransformationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidTransformException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public XMLSignatureInput getTransformsOutput() {
        return this._transformsOutput;
    }

    protected void dereferenceURIandPerformTransforms() throws XMLSignatureException {
        try {
            XMLSignatureInput input = this.getContentsBeforeTransformation();
            XMLSignatureInput output = this.getContentsAfterTransformation(input);
            if (!CacheSignedNodes) {
                this._transformsInput = new XMLSignatureInput(input.getBytes());
                this._transformsInput.setSourceURI(input.getSourceURI());
                this._transformsOutput = new XMLSignatureInput(output.getBytes());
                this._transformsOutput.setSourceURI(output.getSourceURI());
            }
        }
        catch (IOException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        Element transformsElement = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "Transforms");
        if (transformsElement != null) {
            Transforms transforms = new Transforms(transformsElement, this._baseURI);
            return transforms;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            void ex;
            this.dereferenceURIandPerformTransforms();
            byte[] signedBytes = this.getTransformsOutput().getBytes();
            return ex;
        }
        catch (IOException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    private byte[] calculateDigest() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            byte[] data = this.getReferencedBytes();
            MessageDigestAlgorithm mda = this.getMessageDigestAlgorithm();
            mda.reset();
            mda.update(data);
            byte[] calculatedDigestValue = mda.digest();
            if (data.length < 20) {
                cat.debug(new String(data));
            } else {
                cat.debug(new String(data));
            }
            return calculatedDigestValue;
        }
        catch (XMLSecurityException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    public byte[] getDigestValue() throws Base64DecodingException {
        Element digestValueElem = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        byte[] elemDig = Base64.decode(digestValueElem);
        return elemDig;
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] calcDig;
        byte[] elemDig = this.getDigestValue();
        boolean equal = MessageDigestAlgorithm.isEqual(elemDig, calcDig = this.calculateDigest());
        if (!equal) {
            cat.debug("Verification failed for URI \"" + this.getURI() + "\"");
        } else {
            cat.debug("Verification successful for URI \"" + this.getURI() + "\"");
        }
        return equal;
    }

    public String getBaseLocalName() {
        return "Reference";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

