/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.content.x509;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.x509.XMLX509DataContent;
import com.systinet.wasp.security.secext.utils.RFC2253Parser;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509IssuerSerial
extends SignatureElementProxy
implements XMLX509DataContent {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509IssuerSerial == null ? (class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509IssuerSerial = XMLX509IssuerSerial.class$("com.systinet.wasp.security.secext.keys.content.x509.XMLX509IssuerSerial")) : class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509IssuerSerial).getName());
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509IssuerSerial;

    public XMLX509IssuerSerial(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public XMLX509IssuerSerial(Document doc, String X509IssuerName, BigInteger X509SerialNumber) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addTextElement(X509IssuerName, "X509IssuerName");
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addTextElement(X509SerialNumber.toString(), "X509SerialNumber");
    }

    public XMLX509IssuerSerial(Document doc, String X509IssuerName, String X509SerialNumber) {
        this(doc, X509IssuerName, new BigInteger(X509SerialNumber));
    }

    public XMLX509IssuerSerial(Document doc, String X509IssuerName, int X509SerialNumber) {
        this(doc, X509IssuerName, new BigInteger(Integer.toString(X509SerialNumber)));
    }

    public XMLX509IssuerSerial(Document doc, X509Certificate x509certificate) {
        this(doc, RFC2253Parser.normalize(x509certificate.getIssuerDN().getName()), x509certificate.getSerialNumber());
    }

    public BigInteger getSerialNumber() throws XMLSecurityException {
        String text = this.getTextFromChildElement("X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#");
        return new BigInteger(text);
    }

    public int getSerialNumberInteger() throws XMLSecurityException {
        return this.getSerialNumber().intValue();
    }

    public String getIssuerName() throws XMLSecurityException {
        return RFC2253Parser.normalize(this.getTextFromChildElement("X509IssuerName", "http://www.w3.org/2000/09/xmldsig#"));
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509IssuerSerial other = (XMLX509IssuerSerial)obj;
        try {
            return other.getSerialNumber().equals(this.getSerialNumber()) && other.getIssuerName().equals(this.getIssuerName());
        }
        catch (XMLSecurityException ex) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509IssuerSerial";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

