/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.exceptions;

import com.systinet.wasp.security.secext.utils.I18n;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class XMLSecurityException
extends Exception {
    protected Exception originalException = null;
    protected String msgID;

    public XMLSecurityException() {
        super("Missing message string");
        this.msgID = null;
        this.originalException = null;
    }

    public XMLSecurityException(String msgID) {
        super(I18n.getExceptionMessage(msgID));
        this.msgID = msgID;
        this.originalException = null;
    }

    public XMLSecurityException(String msgID, Object[] exArgs) {
        super(MessageFormat.format(I18n.getExceptionMessage(msgID), exArgs));
        this.msgID = msgID;
        this.originalException = null;
    }

    public XMLSecurityException(Exception originalException) {
        super("Missing message ID to locate message string in resource bundle \"com/systinet/wasp/security/secext/resource/xmlsecurity\". Original Exception was a " + originalException.getClass().getName() + " and message " + originalException.getMessage());
        this.originalException = originalException;
    }

    public XMLSecurityException(String msgID, Exception originalException) {
        super(I18n.getExceptionMessage(msgID, originalException));
        this.msgID = msgID;
        this.originalException = originalException;
    }

    public XMLSecurityException(String msgID, Object[] exArgs, Exception originalException) {
        super(MessageFormat.format(I18n.getExceptionMessage(msgID), exArgs));
        this.msgID = msgID;
        this.originalException = originalException;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = super.getLocalizedMessage();
        message = message != null ? s + ": " + message : s;
        if (this.originalException != null) {
            message = message + "\nOriginal Exception was " + this.originalException.toString();
        }
        return message;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
            if (this.originalException != null) {
                this.originalException.printStackTrace(System.err);
            }
        }
    }

    public void printStackTrace(PrintWriter printwriter) {
        super.printStackTrace(printwriter);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printwriter);
        }
    }

    public void printStackTrace(PrintStream printstream) {
        super.printStackTrace(printstream);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printstream);
        }
    }

    public Exception getOriginalException() {
        return this.originalException;
    }
}

