/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.implementations;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.MessageDigestAlgorithm;
import com.systinet.wasp.security.secext.algorithms.SignatureAlgorithmSpi;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class IntegrityHmac
extends SignatureAlgorithmSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1 == null ? (class$com$systinet$wasp$security$secext$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1 = IntegrityHmac.class$("com.systinet.wasp.security.secext.algorithms.implementations.IntegrityHmac$IntegrityHmacSHA1")) : class$com$systinet$wasp$security$secext$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1).getName());
    private Mac _macAlgorithm = null;
    int _HMACOutputLength = 0;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1;
    static /* synthetic */ Class class$javax$crypto$SecretKey;

    public abstract String engineGetURI();

    public IntegrityHmac() throws XMLSignatureException {
        JCEMapper.ProviderIdClass algorithmID = JCEMapper.translateURItoJCEID(this.engineGetURI());
        try {
            this._macAlgorithm = Mac.getInstance(algorithmID.getAlgorithmID(), algorithmID.getProviderId());
        }
        catch (NoSuchAlgorithmException ex) {
            Object[] exArgs = new Object[]{algorithmID.getAlgorithmID(), ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
        catch (NoSuchProviderException ex) {
            Object[] exArgs = new Object[]{algorithmID.getProviderId(), ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchProvider", exArgs);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        throw new XMLSignatureException("empty", new Object[]{"HMAC does not require any parameters"});
    }

    protected boolean engineVerify(byte[] signature) throws XMLSignatureException {
        try {
            byte[] completeResult = this._macAlgorithm.doFinal();
            if (this._HMACOutputLength == 0 || this._HMACOutputLength >= 160) {
                return MessageDigestAlgorithm.isEqual(completeResult, signature);
            }
            byte[] stripped = IntegrityHmac.reduceBitLength(completeResult, this._HMACOutputLength);
            return MessageDigestAlgorithm.isEqual(stripped, signature);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineInitVerify(Key secretKey) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = (class$javax$crypto$SecretKey == null ? (class$javax$crypto$SecretKey = IntegrityHmac.class$("javax.crypto.SecretKey")) : class$javax$crypto$SecretKey).getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] completeResult = this._macAlgorithm.doFinal();
            if (this._HMACOutputLength == 0 || this._HMACOutputLength >= 160) {
                return completeResult;
            }
            return IntegrityHmac.reduceBitLength(completeResult, this._HMACOutputLength);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    private static byte[] reduceBitLength(byte[] completeResult, int length) {
        int bytes = length / 8;
        int abits = length % 8;
        byte[] strippedResult = new byte[bytes + (abits == 0 ? 0 : 1)];
        System.arraycopy(completeResult, 0, strippedResult, 0, bytes);
        if (abits > 0) {
            byte[] MASK = new byte[]{0, -128, -64, -32, -16, -8, -4, -2};
            strippedResult[bytes] = (byte)(completeResult[bytes] & MASK[abits]);
        }
        return strippedResult;
    }

    protected void engineInitSign(Key secretKey) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = (class$javax$crypto$SecretKey == null ? (class$javax$crypto$SecretKey = IntegrityHmac.class$("javax.crypto.SecretKey")) : class$javax$crypto$SecretKey).getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineInitSign(Key secretKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = (class$javax$crypto$SecretKey == null ? (class$javax$crypto$SecretKey = IntegrityHmac.class$("javax.crypto.SecretKey")) : class$javax$crypto$SecretKey).getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey, algorithmParameterSpec);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineInitSign(Key secretKey, SecureRandom secureRandom) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseSecureRandomOnMAC");
    }

    protected void engineUpdate(byte[] input) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(input);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineUpdate(byte input) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(input);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineUpdate(byte[] buf, int offset, int len) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(buf, offset, len);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this._macAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._macAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int HMACOutputLength) {
        this._HMACOutputLength = HMACOutputLength;
    }

    protected void engineGetContextFromElement(Element element) throws XMLSignatureException {
        super.engineGetContextFromElement(element);
        if (element == null) {
            throw new XMLSignatureException("empty", new Object[]{"No element (null) specified for HMAC context"});
        }
        if (element.getChildNodes() != null && element.getChildNodes().getLength() > 0) {
            try {
                Element nscontext = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
                Text hmaclength = (Text)XPathAPI.selectSingleNode((Node)element, (String)"./ds:HMACOutputLength/text()", (Node)nscontext);
                if (hmaclength != null) {
                    this._HMACOutputLength = Integer.parseInt(hmaclength.getData());
                }
            }
            catch (TransformerException ex) {
                throw new XMLSignatureException("empty", ex);
            }
        }
    }

    protected void engineAddContextToElement(Element element) throws XMLSignatureException {
        if (element == null) {
            throw new XMLSignatureException("empty", new Object[]{"No element (null) specified for HMAC context"});
        }
        if (this._HMACOutputLength != 0) {
            Document doc = element.getOwnerDocument();
            Element HMElem = XMLUtils.createElementInSignatureSpace(doc, "HMACOutputLength");
            Text HMText = doc.createTextNode(new Integer(this._HMACOutputLength).toString());
            HMElem.appendChild(HMText);
            XMLUtils.addReturnToElement(element);
            element.appendChild(HMElem);
            XMLUtils.addReturnToElement(element);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class IntegrityHmacMD5
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
        }
    }

    public static class IntegrityHmacRIPEMD160
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
        }
    }

    public static class IntegrityHmacSHA512
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }
    }

    public static class IntegrityHmacSHA384
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }
    }

    public static class IntegrityHmacSHA256
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }
    }

    public static class IntegrityHmacSHA1
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }
    }
}

