/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.implementations.BC;

import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethodSpi;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.PRNG;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BlockEncryptionImpl
extends EncryptionMethodSpi {
    Cipher _cipher;
    public static final boolean ENCRYPT_IV_IN_ECB = false;

    public abstract String getRequiredProviderName();

    public abstract String getImplementedAlgorithmURI();

    public int getImplementedAlgorithmType() {
        return 1;
    }

    public int engineGetBlockSize() {
        try {
            Cipher cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            return cipher.getBlockSize();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public abstract int engineGetIvLength();

    public EncryptionMethodParams engineInit(Document doc, EncryptionMethodParams params) throws XMLSecurityException {
        if (params != null) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return params;
    }

    public EncryptionMethodParams engineInit(Element encryptionMethodElem) throws XMLSecurityException {
        if (encryptionMethodElem.getChildNodes().getLength() != 0) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return null;
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotWrapUnWrap");
    }

    public byte[] engineWrap(Key parm1, Key parm2, byte[] parm3) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotWrapUnWrap");
    }

    public Key engineUnwrap(byte[] parm1, Key parm2, String parm3) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotWrapUnWrap");
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey) throws XMLSecurityException {
        return this.engineEncrypt(plaintextBytes, contentKey, null);
    }

    private String getImplementedIVAlgorithmJCE() {
        return JCEMapper.getJCEIVAlgorithmFromURI(this.getImplementedAlgorithmURI(), this.getRequiredProviderName());
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey, byte[] IV) throws XMLSecurityException {
        try {
            int ivLength = this.engineGetIvLength();
            Cipher cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            if (IV == null) {
                IV = PRNG.createBytes(ivLength);
            }
            IvParameterSpec ivParamSpec = new IvParameterSpec(IV);
            cipher.init(1, contentKey, ivParamSpec);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(plaintextBytes.length);
            baos.write(IV);
            byte[] t = cipher.update(plaintextBytes);
            if (t != null) {
                baos.write(t);
            }
            if ((t = cipher.doFinal()) != null) {
                baos.write(t);
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (BadPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] engineDecrypt(byte[] ciphertextBytes, Key contentKey) throws XMLSecurityException {
        try {
            int ivLength = this.engineGetIvLength();
            byte[] IV = new byte[ivLength];
            System.arraycopy(ciphertextBytes, 0, IV, 0, ivLength);
            IvParameterSpec ivParamSpec = new IvParameterSpec(IV);
            this._cipher.init(2, contentKey, ivParamSpec);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(ciphertextBytes.length);
            byte[] bytes = this._cipher.update(ciphertextBytes, ivLength, ciphertextBytes.length - ivLength);
            if (bytes != null) {
                baos.write(bytes);
            }
            if ((bytes = this._cipher.doFinal()) != null) {
                baos.write(bytes);
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (BadPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }
}

