/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.Algorithm;
import com.systinet.wasp.security.secext.algorithms.SignatureAlgorithmSpi;
import com.systinet.wasp.security.secext.exceptions.AlgorithmAlreadyRegisteredException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$algorithms$SignatureAlgorithm == null ? (class$com$systinet$wasp$security$secext$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("com.systinet.wasp.security.secext.algorithms.SignatureAlgorithm")) : class$com$systinet$wasp$security$secext$algorithms$SignatureAlgorithm).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    protected SignatureAlgorithmSpi _signatureAlgorithm = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$algorithms$SignatureAlgorithm;

    public SignatureAlgorithm(Document doc, String algorithmURI) throws XMLSecurityException {
        super(doc, algorithmURI);
        try {
            String implementingClass = SignatureAlgorithm.getImplementingClass(algorithmURI);
            this._signatureAlgorithm = (SignatureAlgorithmSpi)Class.forName(implementingClass).newInstance();
        }
        catch (ClassNotFoundException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (NullPointerException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ((Throwable)ex).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
    }

    public SignatureAlgorithm(Document doc, String algorithmURI, int HMACOutputLength) throws XMLSecurityException {
        this(doc, algorithmURI);
        this._signatureAlgorithm.engineSetHMACOutputLength(HMACOutputLength);
        this._signatureAlgorithm.engineAddContextToElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        String algorithmURI = this.getURI();
        try {
            String implementingClass = SignatureAlgorithm.getImplementingClass(algorithmURI);
            this._signatureAlgorithm = (SignatureAlgorithmSpi)Class.forName(implementingClass).newInstance();
            this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
        }
        catch (ClassNotFoundException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (NullPointerException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ((Throwable)ex).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        return this._signatureAlgorithm.engineGetJCEAlgorithmString();
    }

    public String getJCEProviderName() {
        return this._signatureAlgorithm.engineGetJCEProviderName();
    }

    public void update(byte[] input) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(input);
    }

    public void update(byte input) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(input);
    }

    public void update(byte[] buf, int offset, int len) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(buf, offset, len);
    }

    public void initSign(Key signingKey) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(signingKey);
    }

    public void initSign(Key signingKey, SecureRandom secureRandom) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(signingKey, secureRandom);
    }

    public void initSign(Key signingKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(signingKey, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(params);
    }

    public void initVerify(Key verificationKey) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitVerify(verificationKey);
    }

    public boolean verify(byte[] signature) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(signature);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (cat == null) {
            cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$algorithms$SignatureAlgorithm == null ? (class$com$systinet$wasp$security$secext$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("com.systinet.wasp.security.secext.algorithms.SignatureAlgorithm")) : class$com$systinet$wasp$security$secext$algorithms$SignatureAlgorithm).getName());
        }
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        String registeredClass = SignatureAlgorithm.getImplementingClass(algorithmURI);
        if (registeredClass != null && registeredClass.length() != 0) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        _algorithmHash.put(algorithmURI, implementingClass);
    }

    private static String getImplementingClass(String URI) {
        if (_algorithmHash == null) {
            return null;
        }
        return (String)_algorithmHash.get(URI);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

