/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.security.policy.xml;

import com.idoox.config.xml.XMLConfigurator;
import com.systinet.security.policy.Acl;
import com.systinet.security.policy.Acl2JavaAcl;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import org.idoox.config.Configurable;
import org.idoox.config.IConfigurator;
import org.idoox.security.WASPPrincipal;
import org.idoox.security.pstore.NotificationEvent;
import org.idoox.security.pstore.NotificationListener;
import org.systinet.security.perm.WASPPermissions;
import org.systinet.security.policy.PrincipalEntries;
import org.systinet.security.policy.UpdateablePolicy;

public class XMLUpdateablePolicy
extends UpdateablePolicy
implements NotificationListener {
    private static final Map NULL_MAP = new HashMap(1);
    private Acl acl;
    private Acl2JavaAcl cachedAcl;
    private IConfigurator configurator;
    protected Object sync = new Object();
    private WeakHashMap permissionCollectionCache = null;
    static /* synthetic */ Class class$com$systinet$security$policy$Acl;

    public XMLUpdateablePolicy(Map parameters) {
        super(parameters);
        if (parameters == null) {
            parameters = NULL_MAP;
        }
        String policyFileLocation = (String)parameters.get("wasp.policy.xml.file");
        this.init(policyFileLocation);
        Object cache = parameters.get("wasp.policy.xml.resultcache");
        if (cache != null && cache.toString().equalsIgnoreCase("true")) {
            this.permissionCollectionCache = new WeakHashMap();
        }
    }

    private void init(String filename) {
        HashMap<String, String> initParm = new HashMap<String, String>(3);
        filename = filename.replace('\\', '/');
        int index = filename.lastIndexOf(47);
        String base = filename.substring(0, index);
        String file = filename.substring(index + 1);
        initParm.put("wasp.location", base);
        initParm.put("wasp.config.location", file);
        this.configurator = new XMLConfigurator();
        this.configurator.init(initParm);
        Configurable configurable = null;
        Configurable[] configurables = this.configurator.getTopEntries("acl");
        int i = 0;
        while (i < configurables.length) {
            configurable = configurables[i];
            if (configurable.getName().equals("wasp")) break;
            ++i;
        }
        this.acl = (Acl)configurable.narrow(class$com$systinet$security$policy$Acl == null ? (class$com$systinet$security$policy$Acl = XMLUpdateablePolicy.class$("com.systinet.security.policy.Acl")) : class$com$systinet$security$policy$Acl);
    }

    public XMLUpdateablePolicy(IConfigurator configurator, Acl acl) {
        super(null);
        this.configurator = configurator;
        this.acl = acl;
    }

    public boolean isUpdatable() {
        return true;
    }

    private Acl2JavaAcl getCachedAcl() {
        Object object = this.sync;
        synchronized (object) {
            if (this.cachedAcl == null) {
                this.cachedAcl = new Acl2JavaAcl(this.acl);
            }
            if (this.permissionCollectionCache != null) {
                this.permissionCollectionCache.clear();
            }
            Acl2JavaAcl acl2JavaAcl = this.cachedAcl;
            return acl2JavaAcl;
        }
    }

    protected void invalidateCache() {
        Object object = this.sync;
        synchronized (object) {
            this.cachedAcl = null;
        }
    }

    public void addPermissions(CodeSource cs, Principal principal, PermissionCollection collection) throws AccessControlException {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            acl.addPermissions(principal, collection);
        }
    }

    public boolean addPermission(CodeSource cs, Principal principal, Permission permission) throws AccessControlException {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            boolean bl = acl.addPermission(principal, permission);
            return bl;
        }
    }

    public boolean removePermission(CodeSource cs, Principal principal, Permission permission) throws AccessControlException {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            boolean bl = acl.removePermission(principal, permission);
            return bl;
        }
    }

    public void refresh() {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl cacl = this.getCachedAcl();
            this.acl.setRole(cacl.getRoles());
            this.acl.setGrant(cacl.getGrants());
            this.configurator.flush();
            this.invalidateCache();
        }
    }

    public PermissionCollection getPermissions(Subject subject, CodeSource cs) {
        Object perms;
        if (this.permissionCollectionCache != null) {
            Object object = this.sync;
            synchronized (object) {
                perms = (PermissionCollection)this.permissionCollectionCache.get(subject);
                if (perms != null) {
                    Object object2 = perms;
                    return object2;
                }
                perms = new WASPPermissions();
                Acl2JavaAcl acl = this.getCachedAcl();
                acl.fillPermissions(subject, (PermissionCollection)perms);
                ((PermissionCollection)perms).setReadOnly();
                if (this.permissionCollectionCache != null) {
                    this.permissionCollectionCache.put(subject, perms);
                }
            }
        } else {
            perms = new WASPPermissions();
            Acl2JavaAcl acl = this.getCachedAcl();
            acl.fillPermissions(subject, (PermissionCollection)perms);
            ((PermissionCollection)perms).setReadOnly();
        }
        return perms;
    }

    public PermissionCollection getPrincipalPermissions(CodeSource cs, Principal principal) throws AccessControlException {
        Object object = this.sync;
        synchronized (object) {
            WASPPermissions perms = new WASPPermissions();
            Acl2JavaAcl acl = this.getCachedAcl();
            acl.fillPermissions(principal, (PermissionCollection)perms);
            perms.setReadOnly();
            WASPPermissions wASPPermissions = perms;
            return wASPPermissions;
        }
    }

    public PermissionCollection getPrincipalPermissions(CodeSource cs, Principal principal, boolean roleInheritted) throws AccessControlException {
        Object object = this.sync;
        synchronized (object) {
            WASPPermissions perms = new WASPPermissions();
            Acl2JavaAcl acl = this.getCachedAcl();
            acl.fillPermissions(principal, (PermissionCollection)perms, roleInheritted);
            perms.setReadOnly();
            WASPPermissions wASPPermissions = perms;
            return wASPPermissions;
        }
    }

    public PrincipalEntries getPrincipalEntries() throws AccessControlException {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            PrincipalEntries principalEntries = acl.getPrincipalEntries();
            return principalEntries;
        }
    }

    public PrincipalEntries getPrincipalEntries(Permission perm) throws AccessControlException {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            PrincipalEntries principalEntries = acl.getPrincipalEntries(perm);
            return principalEntries;
        }
    }

    public boolean isRoleManager() {
        return true;
    }

    public Iterator getRoleNames() {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            Iterator iterator = acl.getRoleNames();
            return iterator;
        }
    }

    public boolean addPermissionToRole(String roleName, Permission permission) {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            boolean bl = acl.addPermissionToRole(roleName, permission);
            return bl;
        }
    }

    public boolean removePermissionFromRole(String roleName, Permission permission) {
        Object object = this.sync;
        synchronized (object) {
            Acl2JavaAcl acl = this.getCachedAcl();
            boolean bl = acl.removePermissionFromRole(roleName, permission);
            return bl;
        }
    }

    public PermissionCollection getRolePermissions(String roleName) {
        Object object = this.sync;
        synchronized (object) {
            WASPPermissions perms = new WASPPermissions();
            Acl2JavaAcl acl = this.getCachedAcl();
            acl.fillRolePermissions(roleName, (PermissionCollection)perms);
            perms.setReadOnly();
            WASPPermissions wASPPermissions = perms;
            return wASPPermissions;
        }
    }

    public void notificationReceived(NotificationEvent evt) {
        if ((evt.getTypeMask() & 1) > 0) {
            Object object = this.sync;
            synchronized (object) {
                Acl2JavaAcl acl = this.getCachedAcl();
                acl.removePrincipalEntry((Principal)new WASPPrincipal(evt.getName()));
            }
            this.refresh();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

