/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.xml.ReaderTokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.idoox.transport.InputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.SignatureException;

public class UriResolver {
    public static Tokenizer resolve(String uri, Tokenizer defaultDocument) throws SignatureException {
        try {
            if (!UriResolver.isFragmentOnly(uri)) {
                byte[] sourceBytes = UriResolver.getBytes(uri);
                ReaderTokenizer tokenizer = new ReaderTokenizer((InputStream)new ByteArrayInputStream(sourceBytes));
                tokenizer.next();
                return tokenizer;
            }
            String id = uri.substring(1);
            while (true) {
                byte state;
                if ((state = defaultDocument.next()) == 1) {
                    throw new SignatureException("Error resolving URI. Fragment " + id + " not found.");
                }
                if (state != 2) continue;
                Token token = new Token();
                defaultDocument.readToken(token);
                String tempId = token.getAttributeValue(null, "id");
                if (tempId != null && tempId.equals(id)) break;
            }
            return defaultDocument;
        }
        catch (Exception e) {
            throw new SignatureException("Error resolving URI. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private static boolean isFragmentOnly(String uri) {
        return uri.startsWith("#");
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getBytes(String uri) throws MalformedURLException, IOException {
        int length;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        Endpoint endpoint = new Endpoint(uri);
        ClientConnection connection = endpoint.newConnection(TransportMethod.GET);
        InputMessage in = connection.getInputMessage();
        byte[] buffer = new byte[2048];
        while ((length = in.read(buffer, 0, buffer.length)) != -1) {
            void var6_6;
            if (var6_6 <= 0) continue;
            bo.write(buffer, 0, (int)var6_6);
        }
        byte[] ret = bo.toByteArray();
        in.close();
        bo.close();
        return ret;
    }
}

