/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.xml.security.TokenizerProcessor;
import java.io.IOException;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.security.SignatureException;

public class TokenizerUtil {
    public static byte tokenizerNext(Tokenizer tokenizer, int[] depth) throws IOException, TokenizerException {
        byte oldState = tokenizer.currentState();
        byte state = tokenizer.next();
        if (oldState == 2) {
            if (state == 2) {
                depth[0] = depth[0] + 1;
            } else if (state == 4) {
                depth[0] = depth[0] + 1;
            } else if (state == 3) {
                // empty if block
            }
        } else if (oldState == 4) {
            if (state != 2 && state != 4 && state == 3) {
                depth[0] = depth[0] - 1;
            }
        } else if (oldState == 3 && state != 2 && state != 4 && state == 3) {
            depth[0] = depth[0] - 1;
        }
        return state;
    }

    public static byte nextToStartToken(Tokenizer tokenizer, int[] depth) throws TokenizerException, IOException {
        byte state = TokenizerUtil.tokenizerNext(tokenizer, depth);
        if (state == 4) {
            state = TokenizerUtil.tokenizerNext(tokenizer, depth);
        }
        if (state != 2) {
            throw new TokenizerException("can't reach startToken state");
        }
        return state;
    }

    public static void constructChildrenElements(TokenizerProcessor handler, Tokenizer source) throws SignatureException {
        int[] depth = new int[]{0};
        try {
            byte currentState = TokenizerUtil.nextToStartToken(source, depth);
            int depthCycle = depth[0];
            while (currentState == 2) {
                boolean handled = handler.constructElement(source);
                if (source.currentState() == 2) {
                    currentState = TokenizerUtil.tokenizerNext(source, depth);
                    while (depth[0] > depthCycle || depth[0] == depthCycle && currentState != 3) {
                        currentState = TokenizerUtil.tokenizerNext(source, depth);
                    }
                }
                currentState = TokenizerUtil.tokenizerNext(source, depth);
                while (depth[0] > depthCycle || depth[0] == depthCycle && currentState == 4) {
                    currentState = TokenizerUtil.tokenizerNext(source, depth);
                }
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error constructing element. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public static Tokenizer getSignature(Tokenizer envelope) throws TokenizerException, IOException {
        byte state = envelope.currentState();
        while (state != 1) {
            String namespace;
            if (state == 2 && (namespace = envelope.getNamespace()) != null && namespace.equals("http://www.w3.org/2000/09/xmldsig#")) {
                return envelope;
            }
            state = envelope.next();
        }
        return null;
    }
}

