/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.wasp.Constants;
import com.idoox.xml.security.TokenizerProcessor;
import com.idoox.xml.security.TokenizerUtil;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.idoox.util.Base64;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.KeyContent;
import org.idoox.xml.security.KeyValueContent;
import org.idoox.xml.security.SignatureException;

public class RSAKeyContent
extends KeyValueContent
implements TokenizerProcessor {
    private BigInteger modulus;
    private BigInteger exponent;

    public RSAKeyContent() {
        this.qname = KeyContent.RSA_KEYCONTENT;
    }

    public void construct(Tokenizer tokenizedKeyContent) throws SignatureException {
        TokenizerUtil.constructChildrenElements(this, tokenizedKeyContent);
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            String name = tokenizer.getLocalName();
            if (name.equals("Modulus")) {
                tokenizer.next();
                String modulusStr = tokenizer.readContent();
                this.modulus = new BigInteger(1, Base64.decode((byte[])modulusStr.getBytes(Constants.UTF_8)));
                tokenizer.next();
                return true;
            }
            if (name.equals("Exponent")) {
                tokenizer.next();
                String exponentStr = tokenizer.readContent();
                this.exponent = new BigInteger(1, Base64.decode((byte[])exponentStr.getBytes(Constants.UTF_8)));
                tokenizer.next();
                return true;
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating RSAKezValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
        return false;
    }

    public void construct(Object keyData) throws SignatureException {
        if (!(keyData instanceof RSAPublicKey)) {
            throw new SignatureException("cannot construct RSAKeyContent with a given type of PublicKey: " + keyData.getClass().getName());
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyData;
        this.modulus = rsaPublicKey.getModulus();
        this.exponent = rsaPublicKey.getPublicExponent();
    }

    public String toCanonicalXMLString(String signaturePrefix) throws SignatureException {
        try {
            byte[] encodedByteArray = null;
            StringBuffer sb = new StringBuffer();
            String startTag = "";
            String endTag = "";
            if (!signaturePrefix.equals("")) {
                startTag = "<" + signaturePrefix + ":";
                endTag = "</" + signaturePrefix + ":";
            } else {
                startTag = "<";
                endTag = "</";
            }
            sb.append(startTag).append("KeyValue>\n");
            sb.append(startTag).append("RSAKeyValue>\n");
            if (this.modulus != null) {
                sb.append(startTag).append("Modulus>");
                encodedByteArray = Base64.encode((byte[])this.modulus.toByteArray(), (boolean)false);
                sb.append(new String(encodedByteArray, Constants.UTF_8));
                sb.append(endTag).append("Modulus>\n");
            }
            if (this.exponent != null) {
                sb.append(startTag).append("Exponent>");
                encodedByteArray = Base64.encode((byte[])this.exponent.toByteArray(), (boolean)false);
                sb.append(new String(encodedByteArray, Constants.UTF_8));
                sb.append(endTag).append("Exponent>\n");
            }
            sb.append(endTag).append("RSAKeyValue>\n");
            sb.append(endTag).append("KeyValue>");
            return sb.toString();
        }
        catch (Exception e) {
            throw new SignatureException("Error creating RSAKeyValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public PublicKey getPublicKey() throws SignatureException {
        try {
            KeyFactory rsaFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rsaKeyspec = new RSAPublicKeySpec(this.modulus, this.exponent);
            PublicKey pk = rsaFactory.generatePublic(rsaKeyspec);
            return pk;
        }
        catch (Exception e) {
            throw new SignatureException("Error creating RSAPublicKey. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public KeyContent newInstance() {
        return new RSAKeyContent();
    }
}

