/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.ssl;

import com.idoox.wasp.security.ssl.SSLServerProvider;
import java.io.IOException;
import org.idoox.config.Configurable;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.TransportInterceptor;

public class SSLInterceptor
implements TransportInterceptor {
    public void intercept(Connection connection, InterceptorChain chain, int position) throws IOException {
        try {
            Current current = Current.getInstance();
            SSLServerProvider provider = (SSLServerProvider)current.getProvider("SSL");
            ReceivedCredentials recCreds = provider.getPresetCurentAccepting();
            if (recCreds == null) {
                throw new RuntimeException("No user is registered with client certificate or no client certificate present.\nNote that the SSL server authentication provider works only if the server side https transport needs client authentication.");
            }
            current.setReceivedCredentials(recCreds);
        }
        catch (Exception e) {
            OutputMessage outputMessage = connection.getOutputMessage();
            if (outputMessage != null) {
                outputMessage.setStatusCode(0);
            }
            throw new IOException("setReceivedCredetials error " + e.getClass().getName() + " " + (e.getMessage() == null ? "" : e.getMessage()));
        }
    }

    public void load(Configurable config) {
    }

    public void destroy() {
    }
}

