/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthHeaderElement;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.XMLWriterReader;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MultipleHeadersException;
import org.idoox.xmlrpc.header.HeaderHelper;

public class DigestInitChallengeHeader
extends AuthHeaderElement {
    protected String userId = "";
    protected String realm = "";
    protected String clientNonce = "";
    protected String digestAlgorithm = "";

    public DigestInitChallengeHeader(String userId, String realm, String digestAlgorithm, String clientNonce, boolean generateClientNonce) {
        this.userId = userId;
        this.realm = realm;
        this.clientNonce = clientNonce;
        this.digestAlgorithm = digestAlgorithm;
        this.authType = (byte)20;
        if (generateClientNonce) {
            this.clientNonce = AuthHeaderElement.genNonce();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getClientNonce() {
        return this.clientNonce;
    }

    public Tokenizer getTokenizer() throws IOException, TokenizerException {
        HeaderHelper helper = HeaderHelper.getInstance();
        XMLWriterReader writerReader = helper.createWriterTokenizer();
        writerReader.enter("http://soap-authentication.org/basic/2001/10/", "InitChallenge");
        writerReader.writeAttribute("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "1");
        if (this.digestAlgorithm != null && this.digestAlgorithm.length() > 0) {
            writerReader.writeAttribute(null, "digest", this.digestAlgorithm);
        }
        writerReader.enter(null, "UserId");
        writerReader.writeContent(this.userId);
        writerReader.leave();
        writerReader.enter(null, "Realm");
        writerReader.writeContent(this.realm);
        writerReader.leave();
        if (this.clientNonce != null && this.clientNonce.length() > 0) {
            writerReader.enter(null, "ClientNonce");
            writerReader.writeContent(this.clientNonce);
            writerReader.leave();
        }
        writerReader.leave();
        writerReader.next();
        return writerReader;
    }

    public static DigestInitChallengeHeader getDigestInitChallengeHeader(Message message) throws MultipleHeadersException, TokenizerException, IOException {
        Tokenizer header = message.getHeader(new QName("http://soap-authentication.org/basic/2001/10/", "InitChallenge"));
        if (header == null) {
            return null;
        }
        Token initToken = new Token();
        header.readToken(initToken);
        String digestAlgorithm = initToken.getAttributeValue(null, "digest");
        header.next();
        header.next();
        String userId = header.readContent();
        header.next();
        header.next();
        header.next();
        String realm = header.readContent();
        header.next();
        header.next();
        String clientNonce = "";
        if (header.currentState() == 2 && header.getLocalName().equals("ClientNonce")) {
            header.next();
            clientNonce = header.readContent();
        }
        return new DigestInitChallengeHeader(userId, realm, digestAlgorithm, clientNonce, false);
    }
}

