/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthData;
import com.idoox.wasp.security.soapauth.AuthenticationHelper;
import com.idoox.wasp.security.soapauth.ClientBasicAuthentication;
import com.idoox.wasp.security.soapauth.ClientDigestAuthentication;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessor;

public class ClientHeaderProcessor
implements HeaderProcessor {
    public void processInput(Message message) throws HeaderProcessingException {
        AuthData authData = null;
        if (authData.getAuthType() == 2) {
            return;
        }
        if (authData.getAuthType() == 0) {
            ClientDigestAuthentication.processInput(message);
            return;
        }
    }

    public void processOutput(Message message) throws HeaderProcessingException {
        AuthData authData = null;
        if (authData.getAuthType() == 2) {
            return;
        }
        try {
            if (authData.getAuthType() == 0) {
                ClientDigestAuthentication.processOutput(message);
                return;
            }
            if (authData.getAuthType() == 1) {
                ClientBasicAuthentication.processOutput(message);
            }
        }
        catch (HeaderProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HeaderProcessingException("Error processing authentication. " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
        AuthData authData = AuthenticationHelper.getClientAuthData(null);
        try {
            if (authData.getAuthType() == 2) {
                return;
            }
            if (authData.getAuthType() == 0) {
                ClientDigestAuthentication.processInputFault(message);
                return;
            }
            if (authData.getAuthType() == 1) {
                ClientBasicAuthentication.processInputFault(message);
                return;
            }
        }
        catch (HeaderProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HeaderProcessingException("Error when creating basic authentication header. " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
        throw new HeaderProcessingException("invalid direction");
    }
}

