/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthenticationHelper;
import com.idoox.wasp.security.soapauth.DigestAuthData;
import com.idoox.wasp.security.soapauth.DigestInitChallengeHeader;
import java.io.IOException;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessingException;

public class ClientDigestAuthentication {
    public static void processOutput(Message message) throws HeaderProcessingException, TokenizerException, MessageProcessingException, IOException {
        DigestAuthData authData = (DigestAuthData)AuthenticationHelper.getClientAuthData(null);
        if (authData.getNextAction() == 1) {
            ClientDigestAuthentication.sendInitChallenge(message, authData);
            return;
        }
        if (authData.getNextAction() == 3) {
            ClientDigestAuthentication.sendClientAuth(message, authData);
            return;
        }
    }

    public static void processInputFault(Message message) throws HeaderProcessingException {
        DigestAuthData authData = (DigestAuthData)AuthenticationHelper.getClientAuthData(null);
        if (authData.getNextAction() == 2) {
            ClientDigestAuthentication.recNextChallenge(message, authData);
        }
    }

    public static void processInput(Message message) throws HeaderProcessingException {
    }

    private static void sendInitChallenge(Message message, DigestAuthData authData) throws IOException, TokenizerException, MessageProcessingException {
        DigestInitChallengeHeader dich = new DigestInitChallengeHeader(authData.getUserId(), authData.getClientRealm(), authData.getDigestAlgorithm(), null, authData.getGenerateClientNonce());
        message.addHeader(dich.getTokenizer());
        authData.setNextAction((byte)2);
    }

    private static void recNextChallenge(Message message, DigestAuthData authData) {
        authData.setNextAction((byte)3);
    }

    private static void sendClientAuth(Message message, DigestAuthData authData) {
        authData.setNextAction((byte)2);
    }
}

