/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthHeaderElement;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.XMLWriterReader;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MultipleHeadersException;
import org.idoox.xmlrpc.header.HeaderHelper;

public class BasicAuthHeaderElement
extends AuthHeaderElement {
    protected String userName;
    protected String password;

    public BasicAuthHeaderElement(String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.authType = 0;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Tokenizer getTokenizer() throws IOException, TokenizerException {
        HeaderHelper helper = HeaderHelper.getInstance();
        XMLWriterReader writerReader = helper.createWriterTokenizer();
        writerReader.enter("http://soap-authentication.org/basic/2001/10/", "BasicAuth");
        writerReader.writeAttribute("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "1");
        writerReader.enter(null, "Name");
        writerReader.writeContent(this.userName);
        writerReader.leave();
        writerReader.enter(null, "Password");
        writerReader.writeContent(this.password);
        writerReader.leave();
        writerReader.leave();
        writerReader.next();
        return writerReader;
    }

    public static BasicAuthHeaderElement getBasicAuthHeaderElement(Message message) throws MultipleHeadersException, TokenizerException, IOException {
        Tokenizer header = message.getHeader(new QName("http://soap-authentication.org/basic/2001/10/", "BasicAuth"));
        if (header == null) {
            return null;
        }
        header.next();
        header.next();
        String userName = header.readContent();
        header.next();
        header.next();
        header.next();
        String password = header.readContent();
        return new BasicAuthHeaderElement(userName, password);
    }
}

