/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.siteminder;

import com.idoox.security.server.PrincipalAuthenticatorImpl;
import com.idoox.wasp.interceptor.InterceptorRepositoryImpl;
import com.idoox.wasp.security.providerbase.ServerProviderBase;
import com.idoox.wasp.security.siteminder.SmInterceptor;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.interceptor.Interceptor;
import org.systinet.logging.Category;

public class SmServerProvider
extends ServerProviderBase {
    private static Category log = Category.getCategory((String)"com.idoox.wasp.security.siteminder.SmServerProvider");
    public static final String PROVIDER_NAME = "Siteminder";
    private static final String INTERCEPTOR_NAME = "SmInterceptor";
    private static boolean initialized = false;
    public static final String LOGIN_CONTEXT_NAME = "HttpRequest";

    public SmServerProvider() {
        this.names = new String[]{PROVIDER_NAME};
        this.serverInterceptorName = INTERCEPTOR_NAME;
        this.authenticator = new PrincipalAuthenticatorImpl(PROVIDER_NAME, LOGIN_CONTEXT_NAME);
        this.serverInterceptorDirection = 1;
    }

    public void resetContexts(Map parameters) {
    }

    public Class getPropertiesIface() {
        return null;
    }

    public void setCurrent(Map parameters) {
        throw new UnsupportedOperationException("SiteMinder security provider cannot be set as an initiating provider");
    }

    public void unsetCurrent(Map parameters) {
        throw new UnsupportedOperationException();
    }

    public void setCurrentInitiating(Map parameters) {
        throw new UnsupportedOperationException("SiteMinder security provider cannot be set as an initiating provider");
    }

    public void unsetCurrentInitiating(Map parameters) {
        throw new UnsupportedOperationException();
    }

    private static Configurable getConfig() {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable configurable = Configurator.getConfigurable((String)"securityProviderPreferences", (String)PROVIDER_NAME);
        return configurable;
    }

    private static synchronized void init() {
        if (!initialized) {
            SmInterceptor smInterceptor = new SmInterceptor();
            try {
                smInterceptor.load(SmServerProvider.getConfig());
            }
            catch (WaspInternalException e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
            InterceptorRepositoryImpl interceptorRepository = (InterceptorRepositoryImpl)Context.getInstance((String)"com.idoox.wasp.interceptor.InterceptorRepository");
            interceptorRepository.addInterceptor(INTERCEPTOR_NAME, (Interceptor)smInterceptor);
            initialized = true;
        }
    }

    public void setCurrentAccepting(Map parameters) {
        if (!initialized) {
            SmServerProvider.init();
        }
        super.setCurrentAccepting(parameters);
    }

    public void unsetCurrentAccepting(Map parameters) {
        super.unsetCurrentAccepting(parameters);
    }
}

