/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.siteminder;

import com.idoox.debug.Category;
import com.idoox.security.jaas.SmLoginModule;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.server.ReceivedCredentialsImpl;
import com.idoox.wasp.security.siteminder.SmProviderConfig;
import com.systinet.wasp.monitoring.events.LogEventAuthSuccess;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.config.Configurable;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.server.ServerConnection;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.StopProcessingException;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventManager;
import org.systinet.wasp.webservice.Current;

public class SmInterceptor
implements TransportInterceptor {
    private static Category log = Category.getCategory((String)"com.idoox.wasp.security.siteminder.SmInterceptor");
    private Set httpHeaderPrefixes = new HashSet();
    private Set cookiePrefixes = new HashSet();
    private static final String COOKIE_HEADER_NAME = "COOKIE";
    private static Set EXCLUDED_NAMES = new HashSet();
    static /* synthetic */ Class class$com$idoox$wasp$security$siteminder$SmProviderConfig;

    public void intercept(Connection connection, InterceptorChain interceptorChain, int i) throws StopProcessingException, IOException {
        InputMessage inputMessage = connection.getInputMessage();
        if (inputMessage == null) {
            log.error("Cannot get input message");
            return;
        }
        Set hns = inputMessage.getHeaderNames();
        if (hns == null) {
            log.error("No header names avaliable");
            return;
        }
        HashMap parameters = new HashMap();
        Iterator headerNames = hns.iterator();
        while (headerNames.hasNext()) {
            String headerName = (String)headerNames.next();
            String headerValue = inputMessage.getStringHeader(headerName);
            this.processHeader(headerName, headerValue, parameters);
        }
        String userId = (String)parameters.get("SM-USERDN");
        UserStore userStore = null;
        try {
            PStore.getInstance((String)"").getUserStore();
        }
        catch (BadPasswordException e) {
            throw new RuntimeWrappedException("Unable get userstore", (Throwable)e);
        }
        Map contextData = Current.getCallContext().getContextData();
        contextData.put(SmLoginModule.CALL_CONTEXT_PARAM_KEY, parameters);
        WaspCallbackHandler handler = new WaspCallbackHandler(userId, null, userStore, contextData);
        org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
        ReceivedCredentialsImpl recCred = new ReceivedCredentialsImpl(userId, "Siteminder", "HttpRequest", (CallbackHandler)handler);
        contextData.remove(SmLoginModule.CALL_CONTEXT_PARAM_KEY);
        current.setReceivedCredentials((ReceivedCredentials)recCred);
        EventManager.fireEvent((Event)new LogEventAuthSuccess(userId, "Siteminder", ((ServerConnection)connection).getClientAddress(), connection.getURI().toExternalForm()));
    }

    public void load(Configurable configurable) throws WaspInternalException {
        SmProviderConfig config = (SmProviderConfig)configurable.narrow(class$com$idoox$wasp$security$siteminder$SmProviderConfig == null ? (class$com$idoox$wasp$security$siteminder$SmProviderConfig = SmInterceptor.class$("com.idoox.wasp.security.siteminder.SmProviderConfig")) : class$com$idoox$wasp$security$siteminder$SmProviderConfig);
        String[] cookiePrefs = config.getCookiePrefixes();
        String[] httpHeaderPrefs = config.getHttpHeaderPrefixes();
        int i = 0;
        while (i < httpHeaderPrefs.length) {
            String httpHeaderPref = httpHeaderPrefs[i];
            this.httpHeaderPrefixes.add(httpHeaderPref);
            ++i;
        }
        int i2 = 0;
        while (i2 < cookiePrefs.length) {
            String cookiesPref = cookiePrefs[i2];
            this.cookiePrefixes.add(cookiesPref);
            ++i2;
        }
    }

    public void destroy() {
    }

    private void processHeader(String headerName, String headerValue, Map parameters) {
        if (headerName.compareToIgnoreCase(COOKIE_HEADER_NAME) == 0) {
            parameters.putAll(this.parseCookiesHeader(headerValue));
        } else if (this.prefixMatch(headerName, this.httpHeaderPrefixes)) {
            parameters.put(headerName, headerValue);
        }
    }

    private Map parseCookiesHeader(String cookieHeader) {
        if (cookieHeader == null) {
            return new HashMap(0);
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(cookieHeader, ";=", true);
        while (stringTokenizer.hasMoreTokens()) {
            String cookieName = stringTokenizer.nextToken().trim();
            if (cookieName.indexOf(59) != -1 || cookieName.indexOf(61) != -1 || EXCLUDED_NAMES.contains(cookieName.toLowerCase()) || !this.prefixMatch(cookieName, this.cookiePrefixes) || !stringTokenizer.hasMoreTokens() || !stringTokenizer.nextElement().equals("=") || !stringTokenizer.hasMoreElements()) continue;
            retVal.put(cookieName, stringTokenizer.nextToken().trim());
        }
        return retVal;
    }

    private boolean prefixMatch(String paramName, Set prefixes) {
        if (prefixes == null || prefixes.isEmpty()) {
            return true;
        }
        Iterator iterator = prefixes.iterator();
        while (iterator.hasNext()) {
            String prefix = (String)iterator.next();
            if (!paramName.startsWith(prefix)) continue;
            return true;
        }
        log.debug("No prefix match the parameter " + paramName);
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EXCLUDED_NAMES.add("path");
        EXCLUDED_NAMES.add("comment");
        EXCLUDED_NAMES.add("domain");
        EXCLUDED_NAMES.add("max-age");
        EXCLUDED_NAMES.add("secure");
        EXCLUDED_NAMES.add("version");
    }
}

