/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.server;

import com.idoox.debug.Category;
import com.idoox.wasp.security.client.CurrentImpl;
import com.idoox.wasp.security.server.CurrentImpl;
import java.security.NoSuchProviderException;
import java.util.Map;
import java.util.Properties;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.spi.ClientSecurityProvider;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.webservice.Current;

public class ClientCurrentImpl
extends org.idoox.security.client.Current {
    private org.idoox.security.server.Current serverCurrent;
    private org.idoox.security.client.Current clientCurrent;
    private ThreadLocal threadCreds = new ThreadLocal();
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.server.ClientCurrentImpl");

    public ClientCurrentImpl() {
        this.serverCurrent = org.idoox.security.server.Current.getInstance();
    }

    private org.idoox.security.client.Current getClientCurrent() {
        if (this.clientCurrent == null) {
            this.clientCurrent = new CurrentImpl();
        }
        return this.clientCurrent;
    }

    private boolean isWSContext() {
        return Current.getServiceEndpointContext() != null;
    }

    public void setCredentials(Credentials[] newCreds) {
        if (this.isWSContext()) {
            this.serverCurrent.setCredentials(newCreds);
        } else {
            this.getClientCurrent().setCredentials(newCreds);
        }
    }

    public void setCredentials(Credentials[] newCreds, Map parameters) {
        if (this.isWSContext()) {
            this.serverCurrent.setCredentials(newCreds, parameters);
        } else {
            this.getClientCurrent().setCredentials(newCreds, parameters);
        }
    }

    public void setCurrentThreadCredentials(Credentials[] creds) {
        Credentials[] current = (Credentials[])this.threadCreds.get();
        if (current == null || creds == null) {
            this.threadCreds.set(creds);
        } else {
            Credentials[] tmp = new Credentials[current.length + creds.length];
            System.arraycopy(current, 0, tmp, 0, current.length);
            System.arraycopy(creds, 0, tmp, current.length, creds.length);
            this.threadCreds.set(tmp);
        }
    }

    public Credentials[] getCredentials() {
        if (this.threadCreds.get() != null) {
            return (Credentials[])this.threadCreds.get();
        }
        if (this.isWSContext()) {
            return this.serverCurrent.getCredentials();
        }
        return this.getClientCurrent().getCredentials();
    }

    public PrincipalAuthenticator getAuthenticator(String provider) throws NoSuchProviderException {
        if (this.isWSContext()) {
            return this.serverCurrent.getAuthenticator(provider);
        }
        return this.getClientCurrent().getAuthenticator(provider);
    }

    public PrincipalAuthenticator getAuthenticator() {
        if (this.isWSContext()) {
            return this.getServerAuthenticator();
        }
        return this.getClientCurrent().getAuthenticator();
    }

    private PrincipalAuthenticator getServerAuthenticator() {
        Map serviceData = Current.getServiceEndpointContext().getContextData();
        CurrentImpl.Provider initiatingProvider = (CurrentImpl.Provider)serviceData.get("security.provider.initiating");
        if (initiatingProvider == null) {
            throw new RuntimeException("Default intiating provider not specified in configuration");
        }
        try {
            return initiatingProvider.getInstance().getAuthenticator();
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void resetCredentials() {
        if (this.isWSContext()) {
            this.serverCurrent.resetCredentials();
        } else {
            this.getClientCurrent().resetCredentials();
        }
        this.threadCreds.set(null);
    }

    public String[] getProviders() {
        if (this.isWSContext()) {
            return this.serverCurrent.getProviders();
        }
        return this.getClientCurrent().getProviders();
    }

    public void registerProvider(String name, String implClassName) {
        if (this.isWSContext()) {
            this.serverCurrent.registerProvider(name, implClassName);
        } else {
            this.getClientCurrent().registerProvider(name, implClassName);
        }
    }

    public Properties getProviderProperties(String name) throws NoSuchProviderException {
        if (this.isWSContext()) {
            return this.serverCurrent.getProviderProperties(name);
        }
        return this.getClientCurrent().getProviderProperties(name);
    }

    public void setCurrentProvider(String name) throws NoSuchProviderException {
        if (this.isWSContext()) {
            this.serverCurrent.setCurrentInitiatingProvider(name);
        } else {
            this.getClientCurrent().setCurrentProvider(name);
        }
    }

    public void setCurrentProvider(String name, Map parameters) throws NoSuchProviderException {
        if (this.isWSContext()) {
            this.serverCurrent.setCurrentInitiatingProvider(name, parameters);
        } else {
            this.getClientCurrent().setCurrentProvider(name, parameters);
        }
    }

    public String getCurrentProvider() {
        if (this.isWSContext()) {
            return this.serverCurrent.getCurrentInitiatingProvider();
        }
        return this.getClientCurrent().getCurrentProvider();
    }

    public ClientSecurityProvider getProvider(String name) throws NoSuchProviderException {
        if (this.isWSContext()) {
            return (ClientSecurityProvider)this.serverCurrent.getProvider(name);
        }
        return this.getClientCurrent().getProvider(name);
    }
}

