/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.pstore;

import com.idoox.config.xml.XMLConfigurator;
import com.idoox.security.util.CryptTools;
import com.idoox.wasp.config.PStoreConfig;
import com.idoox.wasp.security.pstore.PStoreConfigMain;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.IConfigurator;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyEntry;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreException;
import org.idoox.security.pstore.KeyStoreSource;
import org.idoox.security.pstore.PropertyEntry;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.pstore.UserStoreException;
import org.idoox.security.pstore.UserStoreSource;
import org.idoox.security.util.RuntimeWrappedException;
import org.idoox.wasp.Context;

public class ConfigPStoreSource
implements UserStoreSource,
KeyStoreSource {
    private static final int LOAD_MODE = 0;
    private static final int RUNTIME_MODE = 1;
    private int keyStoreMode = 0;
    private int userStoreMode = 0;
    private IConfigurator otherConfigurator;
    private PStoreConfig config;
    CryptTools cryptTools = null;
    private static Map fileSources = new HashMap(11);
    static /* synthetic */ Class class$com$idoox$wasp$security$pstore$PStoreConfigMain;
    static /* synthetic */ Class class$com$idoox$wasp$config$PStoreConfig;

    public ConfigPStoreSource() {
        File configFile = null;
        try {
            String configFileName = System.getProperty("pstore.source.config.file");
            if (configFileName != null && !(configFile = new File(configFileName)).exists()) {
                configFile = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.init(configFile);
        }
        catch (IOException e) {
            throw new RuntimeWrappedException("Unable to load pstore source config file!", (Throwable)e);
        }
    }

    public ConfigPStoreSource(String fileName, boolean useDefaultOnfail) throws IOException {
        File configFile = null;
        String configFileName = fileName;
        if (configFileName != null && !(configFile = new File(configFileName)).exists()) {
            if (useDefaultOnfail) {
                configFile = null;
            } else {
                throw new IOException("File '" + fileName + "' does not exist!");
            }
        }
        this.init(configFile);
    }

    private void init(File configFile) throws IOException {
        IConfigurator configurator;
        String configFileName = configFile == null ? null : configFile.getCanonicalPath();
        if (configFile == null) {
            this.otherConfigurator = configurator = (IConfigurator)Context.getInstance((String)"org.idoox.config.IConfigurator");
        } else {
            Map map = fileSources;
            synchronized (map) {
                if (fileSources.get(configFileName) == null) {
                    configurator = new XMLConfigurator();
                    HashMap<String, String> map2 = new HashMap<String, String>(3, 1.0f);
                    map2.put("wasp.config.location", configFile.getName());
                    try {
                        map2.put("wasp.location", configFile.getCanonicalFile().getParent());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot load configuration file: " + configFile.getName());
                    }
                    configurator.init(map2);
                    this.otherConfigurator = configurator;
                    fileSources.put(configFileName, configurator);
                } else {
                    this.otherConfigurator = configurator = (IConfigurator)fileSources.get(configFileName);
                }
            }
        }
        Configurable c = configurator.getConfigurable("PStore", "main");
        if (c == null) {
            Configurable cMain = configurator.getConfigurable("config", "main");
            if (cMain == null) {
                Map e = fileSources;
                synchronized (e) {
                    if (fileSources.get(configFileName) != null) {
                        fileSources.remove(configFileName);
                    }
                }
                throw new RuntimeException("config 'main' does not exists");
            }
            PStoreConfigMain main = (PStoreConfigMain)cMain.narrow(class$com$idoox$wasp$security$pstore$PStoreConfigMain == null ? (class$com$idoox$wasp$security$pstore$PStoreConfigMain = ConfigPStoreSource.class$("com.idoox.wasp.security.pstore.PStoreConfigMain")) : class$com$idoox$wasp$security$pstore$PStoreConfigMain);
            this.config = main.newPStore();
            this.config.setName("main");
            main.setPStore(this.config);
        } else {
            this.config = (PStoreConfig)c.narrow(class$com$idoox$wasp$config$PStoreConfig == null ? (class$com$idoox$wasp$config$PStoreConfig = ConfigPStoreSource.class$("com.idoox.wasp.config.PStoreConfig")) : class$com$idoox$wasp$config$PStoreConfig);
        }
    }

    public ConfigPStoreSource(IConfigurator configurator) {
        this.otherConfigurator = configurator;
        Configurable c = configurator.getConfigurable("PStore", "main");
        if (c == null) {
            Configurable cMain = configurator.getConfigurable("config", "main");
            if (cMain == null) {
                throw new RuntimeException("config 'main' does not exists");
            }
            PStoreConfigMain main = (PStoreConfigMain)cMain.narrow(class$com$idoox$wasp$security$pstore$PStoreConfigMain == null ? (class$com$idoox$wasp$security$pstore$PStoreConfigMain = ConfigPStoreSource.class$("com.idoox.wasp.security.pstore.PStoreConfigMain")) : class$com$idoox$wasp$security$pstore$PStoreConfigMain);
            this.config = main.newPStore();
            this.config.setName("main");
            main.setPStore(this.config);
        } else {
            this.config = (PStoreConfig)c.narrow(class$com$idoox$wasp$config$PStoreConfig == null ? (class$com$idoox$wasp$config$PStoreConfig = ConfigPStoreSource.class$("com.idoox.wasp.config.PStoreConfig")) : class$com$idoox$wasp$config$PStoreConfig);
        }
    }

    public void load(UserStore userStore, String password) throws BadPasswordException {
        PStoreConfig.UserRecord[] entries;
        block19: {
            this.userStoreMode = 0;
            try {
                PStoreConfig.UserStoreConfig userStoreConfig;
                if (this.cryptTools == null) {
                    this.cryptTools = new CryptTools(password, null);
                    if (this.cryptTools.getSalt() != null) {
                        this.config.setSalt(this.cryptTools.getSalt());
                    }
                }
                if ((userStoreConfig = this.config.getUserStore()) == null) {
                    Object var15_4 = null;
                    this.userStoreMode = 1;
                    return;
                }
                entries = userStoreConfig.getUserRecords();
                if (entries == null) break block19;
                if (entries.length != 0) break block21;
            }
            catch (Throwable throwable) {
                Object var15_7 = null;
                this.userStoreMode = 1;
                throw throwable;
            }
        }
        Object var15_5 = null;
        this.userStoreMode = 1;
        {
            block21: {
                return;
            }
            int i = 0;
            while (i < entries.length) {
                String alias = this.cryptTools.decryptString(entries[i].getAlias());
                PStoreConfig.UserRecord.Property[] properties = entries[i].getProperties();
                if (properties == null || properties.length == 0) {
                    try {
                        userStore.setUserProperties(alias, null);
                    }
                    catch (UserStoreException e) {}
                } else {
                    HashMap<String, Object> mapProperties = new HashMap<String, Object>();
                    int j = 0;
                    while (j < properties.length) {
                        block20: {
                            String key = this.cryptTools.decryptString(properties[j].getKey());
                            byte[] value = this.cryptTools.decryptBytes(properties[j].getValue());
                            Object objectValue = null;
                            try {
                                objectValue = userStore.getPropertySerializer(key).decode(value);
                            }
                            catch (UserStoreException e) {
                                break block20;
                            }
                            mapProperties.put(key, objectValue);
                        }
                        ++j;
                    }
                    try {
                        userStore.setUserProperties(alias, mapProperties);
                    }
                    catch (UserStoreException e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        Object var15_6 = null;
        this.userStoreMode = 1;
    }

    private PStoreConfig.UserRecord createUserRecord(String userId, PropertyEntry[] properties) throws UserStoreException {
        PStoreConfig.UserStoreConfig userStoreConfig = this.config.getUserStore();
        if (userStoreConfig == null) {
            userStoreConfig = this.config.newUserStore();
        }
        PStoreConfig.UserRecord newRecord = userStoreConfig.newUserRecord();
        newRecord.setAlias(this.cryptTools.encryptString(userId));
        if (properties != null && properties.length > 0) {
            PStoreConfig.UserRecord.Property[] recordProperties = new PStoreConfig.UserRecord.Property[properties.length];
            int i = 0;
            while (i < properties.length) {
                PStoreConfig.UserRecord.Property recordProperty = newRecord.newProperty();
                recordProperty.setKey(this.cryptTools.decryptString(properties[i].key));
                recordProperty.setValue(this.cryptTools.encryptBytes(properties[i].value));
                recordProperties[i] = recordProperty;
                ++i;
            }
            newRecord.setProperties(recordProperties);
        }
        return newRecord;
    }

    private int findUserRecord(String userId, PStoreConfig.UserRecord[] records) throws UserStoreException {
        int editId = -1;
        int i = 0;
        while (i < records.length) {
            String currentId = this.cryptTools.decryptString(records[i].getAlias());
            if (currentId.equals(userId)) {
                editId = i;
                break;
            }
            ++i;
        }
        if (editId == -1) {
            throw new UserStoreException("Cannot find user " + userId + ". Record for this doesn't exist.");
        }
        return editId;
    }

    public void addUser(String userId, PropertyEntry[] properties) throws UserStoreException {
        PStoreConfig.UserRecord newRecord;
        PStoreConfig.UserRecord[] records;
        if (this.userStoreMode == 0) {
            return;
        }
        PStoreConfig.UserStoreConfig userStoreConfig = this.config.getUserStore();
        if (userStoreConfig == null) {
            userStoreConfig = this.config.newUserStore();
            this.config.setUserStore(userStoreConfig);
        }
        int newLen = (records = userStoreConfig.getUserRecords()) == null ? 1 : records.length + 1;
        PStoreConfig.UserRecord[] newRecords = new PStoreConfig.UserRecord[newLen];
        if (records != null) {
            System.arraycopy(records, 0, newRecords, 0, records.length);
        }
        newRecords[newRecords.length - 1] = newRecord = this.createUserRecord(userId, properties);
        userStoreConfig.setUserRecords(newRecords);
        if (this.otherConfigurator != null) {
            this.otherConfigurator.flush();
        }
    }

    public void editUser(String userId, PropertyEntry[] properties) throws UserStoreException {
        PStoreConfig.UserRecord newRecord;
        if (this.userStoreMode == 0) {
            return;
        }
        PStoreConfig.UserStoreConfig userStoreConfig = this.config.getUserStore();
        if (userStoreConfig == null) {
            throw new UserStoreException("Cannot edit user " + userId + ". UserStoreConfig doesn't exist.");
        }
        PStoreConfig.UserRecord[] records = userStoreConfig.getUserRecords();
        if (records == null) {
            throw new UserStoreException("Cannot edit user " + userId + ". There isn't any record.");
        }
        int editId = this.findUserRecord(userId, records);
        records[editId] = newRecord = this.createUserRecord(userId, properties);
        userStoreConfig.setUserRecords(records);
        if (this.otherConfigurator != null) {
            this.otherConfigurator.flush();
        }
    }

    public void deleteUser(String userId) throws UserStoreException {
        if (this.userStoreMode == 0) {
            return;
        }
        PStoreConfig.UserStoreConfig userStoreConfig = this.config.getUserStore();
        if (userStoreConfig == null) {
            throw new UserStoreException("Cannot delete user " + userId + ". UserStoreConfig doesn't exist.");
        }
        PStoreConfig.UserRecord[] records = userStoreConfig.getUserRecords();
        if (records == null || records.length == 0) {
            throw new UserStoreException("Cannot delete user " + userId + ". There isn't any record.");
        }
        int removeId = this.findUserRecord(userId, records);
        PStoreConfig.UserRecord[] newRecords = new PStoreConfig.UserRecord[records.length - 1];
        if (removeId > 0) {
            System.arraycopy(records, 0, newRecords, 0, removeId);
        }
        if (newRecords.length - removeId > 0) {
            System.arraycopy(records, removeId + 1, newRecords, removeId, newRecords.length - removeId);
        }
        userStoreConfig.setUserRecords(newRecords);
        if (this.otherConfigurator != null) {
            this.otherConfigurator.flush();
        }
    }

    public void load(KeyStore keystore, String password) throws BadPasswordException {
        PStoreConfig.Record[] entries;
        block17: {
            this.keyStoreMode = 0;
            try {
                PStoreConfig.KeyStoreConfig keyStoreConfig;
                if (this.cryptTools == null) {
                    this.cryptTools = new CryptTools(password, null);
                    if (this.cryptTools.getSalt() != null) {
                        this.config.setSalt(this.cryptTools.getSalt());
                    }
                }
                if ((keyStoreConfig = this.config.getKeyStore()) == null) {
                    Object var16_4 = null;
                    this.keyStoreMode = 1;
                    return;
                }
                entries = keyStoreConfig.getRecords();
                if (entries == null) break block17;
                if (entries.length != 0) break block18;
            }
            catch (Throwable throwable) {
                Object var16_7 = null;
                this.keyStoreMode = 1;
                throw throwable;
            }
        }
        Object var16_5 = null;
        this.keyStoreMode = 1;
        {
            block18: {
                return;
            }
            int i = 0;
            while (i < entries.length) {
                PStoreConfig.Record.Key key = entries[i].getKey();
                PStoreConfig.Record.Cert[] certs = entries[i].getCertificates();
                String alias = this.cryptTools.decryptString(entries[i].getAlias());
                if (certs != null && certs.length != 0) {
                    Certificate[] chain = this.getCertificates(certs);
                    if (key != null) {
                        byte[] alg = this.cryptTools.decryptBytes(key.getAlgorithm());
                        byte[] format = this.cryptTools.decryptBytes(key.getFormat());
                        byte[] encoded = this.cryptTools.decryptBytes(key.getEncoded());
                        byte[] keySalt = this.cryptTools.decryptBytes(key.getSalt());
                        try {
                            keystore.setKeyEntry(alias, encoded, alg, format, keySalt, chain);
                        }
                        catch (KeyStoreException e) {}
                    } else {
                        try {
                            keystore.setCertificateEntry(alias, chain);
                        }
                        catch (KeyStoreException e) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
        Object var16_6 = null;
        this.keyStoreMode = 1;
    }

    private PStoreConfig.Record createRecord(String alias, KeyEntry entry) throws KeyStoreException {
        try {
            PStoreConfig.KeyStoreConfig keyStoreConfig = this.config.getKeyStore();
            if (keyStoreConfig == null) {
                keyStoreConfig = this.config.newKeyStore();
            }
            PStoreConfig.Record record = keyStoreConfig.newRecord();
            record.setAlias(alias);
            if (entry.getEncodedKey() != null) {
                byte[] encoded = this.cryptTools.encryptBytes(entry.getEncodedKey());
                byte[] alg = this.cryptTools.encryptBytes(entry.getAlgorithm());
                byte[] format = this.cryptTools.encryptBytes(entry.getFormat());
                byte[] salt = this.cryptTools.encryptBytes(entry.getSalt());
                PStoreConfig.Record.Key keyConfig = record.newKey();
                keyConfig.setAlgorithm(alg);
                keyConfig.setEncoded(encoded);
                keyConfig.setFormat(format);
                keyConfig.setSalt(salt);
                record.setKey(keyConfig);
            }
            if (entry.getCertificateChain() != null) {
                Certificate[] chain = entry.getCertificateChain();
                PStoreConfig.Record.Cert[] certs = new PStoreConfig.Record.Cert[chain.length];
                int i = 0;
                while (i < chain.length) {
                    String type = this.cryptTools.encryptString(chain[i].getType());
                    byte[] encoded = this.cryptTools.encryptBytes(chain[i].getEncoded());
                    PStoreConfig.Record.Cert cert = record.newCertificate();
                    cert.setEncoded(encoded);
                    cert.setType(type);
                    certs[i] = cert;
                    ++i;
                }
                record.setCertificates(certs);
            }
            return record;
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException("creating record error - CertificateEncoding exception" + (e.getMessage() == null ? "" : e.getMessage()));
        }
    }

    private int findKeyRecord(String alias, PStoreConfig.Record[] records) throws KeyStoreException {
        int editId = -1;
        int i = 0;
        while (i < records.length) {
            String currentAlias = this.cryptTools.decryptString(records[i].getAlias());
            if (currentAlias.equals(alias)) {
                editId = i;
                break;
            }
            ++i;
        }
        if (editId == -1) {
            throw new KeyStoreException("Cannot find alias " + alias + ". Record for this doesn't exist.");
        }
        return editId;
    }

    public void addKey(String alias, KeyEntry keyEntry) throws BadPasswordException, KeyStoreException {
        PStoreConfig.Record newRecord;
        PStoreConfig.Record[] records;
        if (this.keyStoreMode == 0) {
            return;
        }
        PStoreConfig.KeyStoreConfig keyStoreConfig = this.config.getKeyStore();
        if (keyStoreConfig == null) {
            keyStoreConfig = this.config.newKeyStore();
            this.config.setKeyStore(keyStoreConfig);
        }
        int newLen = (records = keyStoreConfig.getRecords()) == null ? 1 : records.length + 1;
        PStoreConfig.Record[] newRecords = new PStoreConfig.Record[newLen];
        if (records != null && records.length > 0) {
            System.arraycopy(records, 0, newRecords, 0, records.length);
        }
        newRecords[newRecords.length - 1] = newRecord = this.createRecord(alias, keyEntry);
        keyStoreConfig.setRecords(newRecords);
        if (this.otherConfigurator != null) {
            this.otherConfigurator.flush();
        }
    }

    public void editKey(String alias, KeyEntry keyEntry) throws BadPasswordException, KeyStoreException {
        PStoreConfig.Record newRecord;
        if (this.keyStoreMode == 0) {
            return;
        }
        PStoreConfig.KeyStoreConfig keyStoreConfig = this.config.getKeyStore();
        if (keyStoreConfig == null) {
            throw new KeyStoreException("Cannot edit key: " + alias + ". keyStoreConfig doesn't exist.");
        }
        PStoreConfig.Record[] records = keyStoreConfig.getRecords();
        if (records == null || records.length == 0) {
            throw new KeyStoreException("Cannot edit key: " + alias + ". There isn't any record in the source.");
        }
        int editId = this.findKeyRecord(alias, records);
        records[editId] = newRecord = this.createRecord(alias, keyEntry);
        keyStoreConfig.setRecords(records);
        if (this.otherConfigurator != null) {
            this.otherConfigurator.flush();
        }
    }

    public void deleteKey(String alias) throws KeyStoreException {
        if (this.keyStoreMode == 0) {
            return;
        }
        PStoreConfig.KeyStoreConfig keyStoreConfig = this.config.getKeyStore();
        if (keyStoreConfig == null) {
            throw new KeyStoreException("Cannot remove key: " + alias + ". keyStoreConfig doesn't exist.");
        }
        PStoreConfig.Record[] records = keyStoreConfig.getRecords();
        if (records == null || records.length == 0) {
            throw new KeyStoreException("Cannot remove key: " + alias + ". There isn't any record in the source.");
        }
        int removeId = this.findKeyRecord(alias, records);
        PStoreConfig.Record[] newRecords = new PStoreConfig.Record[records.length - 1];
        if (removeId > 0) {
            System.arraycopy(records, 0, newRecords, 0, removeId);
        }
        if (newRecords.length - removeId > 0) {
            System.arraycopy(records, removeId + 1, newRecords, removeId, newRecords.length - removeId);
        }
        keyStoreConfig.setRecords(newRecords);
        if (this.otherConfigurator != null) {
            this.otherConfigurator.flush();
        }
    }

    private Certificate[] getCertificates(PStoreConfig.Record.Cert[] certs) throws BadPasswordException {
        Certificate[] retval = new Certificate[certs.length];
        try {
            int i = 0;
            while (i < certs.length) {
                String type = this.cryptTools.decryptString(certs[i].getType());
                CertificateFactory cf = CertificateFactory.getInstance(type);
                byte[] encoded = this.cryptTools.decryptBytes(certs[i].getEncoded());
                ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
                retval[i] = cf.generateCertificate(bin);
                ++i;
            }
        }
        catch (Exception e) {
            throw new BadPasswordException("PStore data corrupted: " + e.getMessage());
        }
        return retval;
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

