/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import com.idoox.wasp.security.kerberos.utils.asn1.DerInputBuffer;
import com.idoox.wasp.security.kerberos.utils.asn1.DerInputStream;
import com.idoox.wasp.security.kerberos.utils.asn1.DerOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private static final int maxFirstComponent = 2;
    private static final int maxSecondComponent = 39;
    private int[] components;
    private int componentLen;
    private static final int allocationQuantum = 5;

    public ObjectIdentifier(String s) throws IOException {
        int byte0 = 46;
        int i = 0;
        int j = 0;
        this.componentLen = 0;
        while ((j = s.indexOf(byte0, i)) != -1) {
            i = j + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        i = 0;
        int k = 0;
        String s1 = null;
        while ((j = s.indexOf(byte0, i)) != -1) {
            s1 = s.substring(i, j);
            this.components[k++] = Integer.valueOf(s1);
            if (this.components[k++] < 0) {
                throw new IOException("oid components must be nonnegative");
            }
            i = j + 1;
        }
        s1 = s.substring(i);
        this.components[k] = Integer.valueOf(s1);
        if (this.components[0] < 0 || this.components[0] > 2) {
            throw new IOException("First oid component is invalid ");
        }
        if (this.components[1] < 0 || this.components[1] > 39) {
            throw new IOException("Second oid component is invalid ");
        }
    }

    public ObjectIdentifier(int[] ai) throws IOException {
        if (ai.length >= 1 && (ai[0] < 0 || ai[0] > 2)) {
            throw new IOException("First oid component is invalid ");
        }
        if (ai.length >= 2 && (ai[1] < 0 || ai[1] > 39)) {
            throw new IOException("Second oid component is invalid ");
        }
        this.components = (int[])ai.clone();
        this.componentLen = ai.length;
    }

    public ObjectIdentifier(DerInputStream derinputstream) throws IOException {
        byte byte0 = (byte)derinputstream.getByte();
        if (byte0 != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + byte0 + ")");
        }
        int i = derinputstream.available() - derinputstream.getLength() - 1;
        if (i < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(derinputstream, i);
    }

    ObjectIdentifier(DerInputBuffer derinputbuffer) throws IOException {
        this.initFromEncoding(new DerInputStream(derinputbuffer), 0);
    }

    private void initFromEncoding(DerInputStream derinputstream, int i) throws IOException {
        boolean flag = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (derinputstream.available() > i) {
            int j = ObjectIdentifier.getComponent(derinputstream);
            if (j < 0) {
                throw new IOException("X509.ObjectIdentifier() -- component values must be nonnegative");
            }
            if (flag) {
                int byte0 = j < 40 ? 0 : (j < 80 ? 1 : 2);
                int k = j - byte0 * 40;
                if (k > 39) {
                    throw new IOException("X509.ObjectIdentifier() -- Invalid second component");
                }
                this.components[0] = byte0;
                this.components[1] = k;
                this.componentLen = 2;
                flag = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] ai = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, ai, 0, this.components.length);
                this.components = ai;
            }
            this.components[this.componentLen++] = j;
        }
        if (derinputstream.available() != i) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DerOutputStream deroutputstream) throws IOException {
        DerOutputStream deroutputstream1 = new DerOutputStream();
        deroutputstream1.write(this.components[0] * 40 + this.components[1]);
        int i = 2;
        while (i < this.componentLen) {
            ObjectIdentifier.putComponent(deroutputstream1, this.components[i]);
            ++i;
        }
        deroutputstream.write((byte)6, deroutputstream1);
    }

    private static int getComponent(DerInputStream derinputstream) throws IOException {
        int j = 0;
        int i = 0;
        while (j < 4) {
            i <<= 7;
            int k = derinputstream.getByte();
            i |= k & 0x7F;
            if ((k & 0x80) == 0) {
                return i;
            }
            ++j;
        }
        throw new IOException("X509.OID, component value too big");
    }

    private static void putComponent(DerOutputStream deroutputstream, int i) throws IOException {
        byte[] abyte0 = new byte[4];
        int j = 0;
        while (j < 4) {
            abyte0[j] = (byte)(i & 0x7F);
            if ((i >>>= 7) == 0) break;
            ++j;
        }
        while (j > 0) {
            deroutputstream.write(abyte0[j] | 0x80);
            --j;
        }
        deroutputstream.write(abyte0[0]);
    }

    public boolean precedes(ObjectIdentifier objectidentifier) {
        if (objectidentifier == this || this.componentLen < objectidentifier.componentLen) {
            return false;
        }
        if (objectidentifier.componentLen < this.componentLen) {
            return true;
        }
        int i = 0;
        while (i < this.componentLen) {
            if (objectidentifier.components[i] < this.components[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)obj);
        }
        return false;
    }

    public boolean equals(ObjectIdentifier objectidentifier) {
        if (objectidentifier == this) {
            return true;
        }
        if (this.componentLen != objectidentifier.componentLen) {
            return false;
        }
        int i = 0;
        while (i < this.componentLen) {
            if (this.components[i] != objectidentifier.components[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        int i = 0;
        String s = "";
        while (i < this.componentLen) {
            if (i != 0) {
                s = s + ".";
            }
            s = s + this.components[i];
            ++i;
        }
        return s;
    }
}

