/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import com.idoox.wasp.security.kerberos.utils.asn1.BigInt;
import com.idoox.wasp.security.kerberos.utils.asn1.BitArray;
import com.idoox.wasp.security.kerberos.utils.asn1.ByteArrayLexOrder;
import com.idoox.wasp.security.kerberos.utils.asn1.ByteArrayTagOrder;
import com.idoox.wasp.security.kerberos.utils.asn1.DerEncoder;
import com.idoox.wasp.security.kerberos.utils.asn1.DerValue;
import com.idoox.wasp.security.kerberos.utils.asn1.ObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream(int i) {
        super(i);
    }

    public DerOutputStream() {
    }

    public void write(byte byte0, byte[] abyte0) throws IOException {
        this.write(byte0);
        this.putLength(abyte0.length);
        this.write(abyte0, 0, abyte0.length);
    }

    public void write(byte byte0, DerOutputStream deroutputstream) throws IOException {
        this.write(byte0);
        this.putLength(deroutputstream.count);
        this.write(deroutputstream.buf, 0, deroutputstream.count);
    }

    public void writeImplicit(byte byte0, DerOutputStream deroutputstream) throws IOException {
        this.write(byte0);
        this.write(deroutputstream.buf, 1, deroutputstream.count - 1);
    }

    public void putDerValue(DerValue dervalue) throws IOException {
        dervalue.encode(this);
    }

    public void putBoolean(boolean flag) throws IOException {
        this.write(1);
        this.putLength(1);
        if (flag) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putInteger(BigInt bigint) throws IOException {
        this.write(2);
        this.putBigInt(bigint);
    }

    public void putInteger(BigInteger biginteger) throws IOException {
        this.write(2);
        byte[] abyte0 = biginteger.toByteArray();
        this.putLength(abyte0.length);
        this.write(abyte0, 0, abyte0.length);
    }

    public void putInteger(Integer integer) throws IOException {
        this.putInteger((int)integer);
    }

    public void putInteger(int i) throws IOException {
        byte[] abyte0 = new byte[4];
        int j = 0;
        abyte0[3] = (byte)(i & 0xFF);
        abyte0[2] = (byte)((i & 0xFF00) >>> 8);
        abyte0[1] = (byte)((i & 0xFF0000) >>> 16);
        abyte0[0] = (byte)((i & 0xFF000000) >>> 24);
        if (abyte0[0] == 255) {
            int k = 0;
            while (k < 3) {
                if (abyte0[k] == 255 && (abyte0[k + 1] & 0x80) == 128) {
                    ++j;
                    ++k;
                    continue;
                }
                break;
            }
        } else if (abyte0[0] == 0) {
            int l = 0;
            while (l < 3) {
                if (abyte0[l] == 0 && (abyte0[l + 1] & 0x80) == 0) {
                    ++j;
                    ++l;
                    continue;
                }
                break;
            }
        }
        this.write(2);
        this.putLength(4 - j);
        int i1 = j;
        while (i1 < 4) {
            this.write(abyte0[i1]);
            ++i1;
        }
    }

    public void putEnumerated(BigInt bigint) throws IOException {
        this.write(10);
        this.putBigInt(bigint);
    }

    private void putBigInt(BigInt bigint) throws IOException {
        byte[] abyte0 = bigint.toByteArray();
        if ((abyte0[0] & 0x80) != 0) {
            this.putLength(abyte0.length + 1);
            this.write(0);
        } else {
            this.putLength(abyte0.length);
        }
        this.write(abyte0, 0, abyte0.length);
    }

    public void putBitString(byte[] abyte0) throws IOException {
        this.write(3);
        this.putLength(abyte0.length + 1);
        this.write(0);
        this.write(abyte0);
    }

    public void putUnalignedBitString(BitArray bitarray) throws IOException {
        byte[] abyte0 = bitarray.toByteArray();
        this.write(3);
        this.putLength(abyte0.length + 1);
        this.write(abyte0.length * 8 - bitarray.length());
        this.write(abyte0);
    }

    public void putOctetString(byte[] abyte0) throws IOException {
        this.write((byte)4, abyte0);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectidentifier) throws IOException {
        objectidentifier.encode(this);
    }

    public void putSequence(DerValue[] adervalue) throws IOException {
        DerOutputStream deroutputstream = new DerOutputStream();
        int i = 0;
        while (i < adervalue.length) {
            adervalue[i].encode(deroutputstream);
            ++i;
        }
        this.write((byte)48, deroutputstream);
    }

    public void putSet(DerValue[] adervalue) throws IOException {
        DerOutputStream deroutputstream = new DerOutputStream();
        int i = 0;
        while (i < adervalue.length) {
            adervalue[i].encode(deroutputstream);
            ++i;
        }
        this.write((byte)49, deroutputstream);
    }

    public void putOrderedSetOf(byte byte0, DerEncoder[] aderencoder) throws IOException {
        this.putOrderedSet(byte0, aderencoder, lexOrder);
    }

    public void putOrderedSet(byte byte0, DerEncoder[] aderencoder) throws IOException {
        this.putOrderedSet(byte0, aderencoder, tagOrder);
    }

    private void putOrderedSet(byte byte0, DerEncoder[] aderencoder, Comparator comparator) throws IOException {
        DerOutputStream[] aderoutputstream = new DerOutputStream[aderencoder.length];
        int i = 0;
        while (i < aderencoder.length) {
            aderoutputstream[i] = new DerOutputStream();
            aderencoder[i].derEncode(aderoutputstream[i]);
            ++i;
        }
        byte[][] abyte0 = new byte[aderoutputstream.length][];
        int j = 0;
        while (j < aderoutputstream.length) {
            abyte0[j] = aderoutputstream[j].toByteArray();
            ++j;
        }
        Arrays.sort(abyte0, comparator);
        DerOutputStream deroutputstream = new DerOutputStream();
        int k = 0;
        while (k < aderoutputstream.length) {
            deroutputstream.write(abyte0[k]);
            ++k;
        }
        this.write(byte0, deroutputstream);
    }

    public void putUTF8String(String s) throws IOException {
        this.writeString(s, (byte)12, "UTF8");
    }

    public void putPrintableString(String s) throws IOException {
        this.writeString(s, (byte)19, "ASCII");
    }

    public void putT61String(String s) throws IOException {
        this.writeString(s, (byte)20, "ISO-8859-1");
    }

    public void putIA5String(String s) throws IOException {
        this.writeString(s, (byte)22, "ASCII");
    }

    public void putBMPString(String s) throws IOException {
        this.writeString(s, (byte)30, "UnicodeBigUnmarked");
    }

    public void putGeneralString(String s) throws IOException {
        this.writeString(s, (byte)27, "ASCII");
    }

    private void writeString(String s, byte byte0, String s1) throws IOException {
        byte[] abyte0 = s.getBytes(s1);
        this.write(byte0);
        this.putLength(abyte0.length);
        this.write(abyte0);
    }

    public void putUTCTime(Date date) throws IOException {
        this.putTime(date, (byte)23);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        this.putTime(date, (byte)24);
    }

    private void putTime(Date date, byte byte0) throws IOException {
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        String s = null;
        if (byte0 == 23) {
            s = "yyMMddHHmmss'Z'";
        } else {
            byte0 = (byte)24;
            s = "yyyyMMddHHmmss'Z'";
        }
        SimpleDateFormat simpledateformat = new SimpleDateFormat(s);
        simpledateformat.setTimeZone(timezone);
        byte[] abyte0 = simpledateformat.format(date).getBytes();
        this.write(byte0);
        this.putLength(abyte0.length);
        this.write(abyte0);
    }

    public void putLength(int i) throws IOException {
        if (i < 128) {
            this.write((byte)i);
        } else if (i < 256) {
            this.write(-127);
            this.write((byte)i);
        } else if (i < 65536) {
            this.write(-126);
            this.write((byte)(i >> 8));
            this.write((byte)i);
        } else if (i < 0x1000000) {
            this.write(-125);
            this.write((byte)(i >> 16));
            this.write((byte)(i >> 8));
            this.write((byte)i);
        } else {
            this.write(-124);
            this.write((byte)(i >> 24));
            this.write((byte)(i >> 16));
            this.write((byte)(i >> 8));
            this.write((byte)i);
        }
    }

    public void putTag(byte byte0, boolean flag, byte byte1) {
        byte byte2 = (byte)(byte0 | byte1);
        if (flag) {
            byte2 = (byte)(byte2 | 0x20);
        }
        this.write(byte2);
    }

    public void derEncode(OutputStream outputstream) throws IOException {
        outputstream.write(this.toByteArray());
    }
}

