/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos;

import com.idoox.debug.Category;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.server.ReceivedCredentialsImpl;
import com.idoox.wasp.security.kerberos.KrbConfiguration;
import com.idoox.wasp.security.kerberos.KrbContext;
import com.idoox.wasp.security.kerberos.KrbNameMapper;
import com.idoox.wasp.security.kerberos.KrbServerInputMessage;
import com.idoox.wasp.security.kerberos.KrbServerOutputMessage;
import com.systinet.wasp.monitoring.events.LogEventAuthFailed;
import com.systinet.wasp.monitoring.events.LogEventAuthSuccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.config.Configurable;
import org.idoox.security.Credentials;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.server.ServerConnection;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.StopProcessingException;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventManager;

public class KrbServerInterceptor
implements TransportInterceptor {
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.kerberos.KrbServerInterceptor");
    private static Hashtable contexts = new Hashtable(11, 0.75f);
    private static long lastSessionID;
    static /* synthetic */ Class class$com$idoox$wasp$security$kerberos$KrbServerInterceptor;

    public void intercept(Connection connection, InterceptorChain chain, int position) throws StopProcessingException, IOException {
        String clientName;
        ServerConnection serverConnection = (ServerConnection)connection;
        InputMessage inMsg = connection.getInputMessage();
        String sessionID = inMsg.getStringHeader("x-idoox-sessionID");
        Context context = null;
        try {
            Hashtable hashtable;
            if (sessionID != null) {
                hashtable = contexts;
                synchronized (hashtable) {
                    context = (Context)contexts.get(sessionID);
                }
            }
            context = KrbServerInterceptor.createContext();
            hashtable = contexts;
            synchronized (hashtable) {
                contexts.put(context.sessionID, context);
            }
            if (!context.gssContext.isEstablished()) {
                KrbServerInterceptor.initContext(connection, context);
                throw new StopProcessingException();
            }
        }
        catch (StopProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            EventManager.fireEvent((Event)new LogEventAuthFailed("", "Kerberos", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
            throw new RuntimeException("Kerberos context cannot be created");
        }
        if (!context.gssContext.isEstablished()) {
            throw new StopProcessingException();
        }
        if (connection.getInputMessage().getStringHeader("x-idoox-sessionInit") != null) {
            throw new StopProcessingException();
        }
        try {
            clientName = context.gssContext.getSrcName().toString();
        }
        catch (GSSException e) {
            EventManager.fireEvent((Event)new LogEventAuthFailed("", "Kerberos", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
            throw new IOException("cannot get clientName from GSSContext");
        }
        clientName = KrbNameMapper.getInstance().getWaspPrincipalName(clientName);
        WaspCallbackHandler handler = new WaspCallbackHandler(clientName);
        Current current = Current.getInstance();
        current.setReceivedCredentials((ReceivedCredentials)new ReceivedCredentialsImpl(clientName, "Kerberos", "NameMapping", (CallbackHandler)handler));
        KrbConfiguration config = KrbServerInterceptor.getConfig();
        connection.setInputMessage((InputMessage)new KrbServerInputMessage(inMsg, context, config));
        connection.setOutputMessage((OutputMessage)new KrbServerOutputMessage(connection.getOutputMessage(), context, config));
    }

    public void load(Configurable config) throws WaspInternalException {
    }

    public void destroy() {
    }

    public static Context createContext() throws PrivilegedActionException {
        Credentials cred = KrbServerInterceptor.getServerCredentials();
        String userId = cred == null ? null : cred.getName();
        Subject subject = cred == null ? null : cred.getSubject();
        GSSContext gssContext = (GSSContext)Subject.doAs(subject, new GSSContextCreator(userId));
        Context ret = null;
        Class clazz = class$com$idoox$wasp$security$kerberos$KrbServerInterceptor == null ? (class$com$idoox$wasp$security$kerberos$KrbServerInterceptor = KrbServerInterceptor.class$("com.idoox.wasp.security.kerberos.KrbServerInterceptor")) : class$com$idoox$wasp$security$kerberos$KrbServerInterceptor;
        synchronized (clazz) {
            ret = new Context(gssContext, Long.toString(lastSessionID++));
        }
        return ret;
    }

    public static void initContext(Connection connection, Context context) throws PrivilegedActionException {
        if (context.gssContext.isEstablished()) {
            return;
        }
        Credentials cred = KrbServerInterceptor.getServerCredentials();
        Subject subject = cred == null ? null : cred.getSubject();
        Subject.doAs(subject, new GSSContextInitiator(connection, context));
    }

    static KrbConfiguration getConfig() {
        return new KrbConfiguration();
    }

    static Credentials getServerCredentials() {
        Current current = Current.getInstance();
        Credentials[] creds = current.getCredentials();
        if (creds == null || creds.length == 0) {
            return null;
        }
        int i = 0;
        while (i < creds.length) {
            if (creds[i] != null && creds[i].getProviderName().equals("Kerberos")) {
                return creds[i];
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ((Timer)org.idoox.wasp.Context.getInstance((String)"java.util.Timer")).schedule((TimerTask)new ContextCleaner(), 3600000L, 3600000L);
        lastSessionID = 0L;
    }

    static class ContextCleaner
    extends TimerTask {
        ContextCleaner() {
        }

        public void run() {
            long TTL = 86400000L;
            long border = System.currentTimeMillis() - TTL;
            Hashtable hashtable = contexts;
            synchronized (hashtable) {
                Set entrySet = contexts.entrySet();
                Iterator it = entrySet.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Context context = (Context)entry.getValue();
                    if (context.lastAccess > border) continue;
                    try {
                        context.gssContext.dispose();
                    }
                    catch (GSSException e) {
                        // empty catch block
                    }
                    entrySet.remove(entry);
                }
            }
        }
    }

    static class Context
    extends KrbContext {
        String sessionID = null;
        long lastAccess;

        public Context(GSSContext gssContext, String sessionID) {
            this.gssContext = gssContext;
            this.sessionID = sessionID;
            this.lastAccess = System.currentTimeMillis();
        }

        public void access() {
            this.lastAccess = System.currentTimeMillis();
        }

        public void dispose() {
            contexts.remove(this.sessionID);
        }
    }

    static class GSSContextInitiator
    implements PrivilegedExceptionAction {
        Connection connection;
        Context context;

        public GSSContextInitiator(Connection connection, Context context) {
            this.context = context;
            this.connection = connection;
        }

        public Object run() throws Exception {
            ServerConnection serverConnection = (ServerConnection)this.connection;
            OutputMessage outMsg = this.connection.getOutputMessage();
            outMsg.setStringHeader("x-idoox-sessionID", this.context.sessionID);
            InputMessage inMsg = this.connection.getInputMessage();
            if (!this.context.gssContext.isEstablished()) {
                this.context.gssContext.acceptSecContext((InputStream)inMsg, (OutputStream)outMsg);
            } else {
                EventManager.fireEvent((Event)new LogEventAuthSuccess(this.context.gssContext.getSrcName().toString(), "Kerberos", serverConnection.getClientAddress(), this.connection.getURI().toExternalForm()));
            }
            outMsg.flush();
            outMsg.close();
            inMsg.close();
            return null;
        }
    }

    static class GSSContextCreator
    implements PrivilegedExceptionAction {
        private String userId;

        public Object run() throws Exception {
            Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
            Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
            GSSName userName = GSSManager.getInstance().createName(this.userId, krb5PrincipalNameType);
            GSSCredential serverCreds = GSSManager.getInstance().createCredential(userName, 0, krb5Mechanism, 2);
            GSSContext context = GSSManager.getInstance().createContext(serverCreds);
            return context;
        }

        public GSSContextCreator(String userId) {
            this.userId = userId;
        }
    }
}

