/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos;

import com.idoox.wasp.security.kerberos.KrbConfiguration;
import com.idoox.wasp.security.kerberos.KrbContext;
import java.io.IOException;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.OutputMessageWrapper;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public abstract class KrbOutputMessage
extends OutputMessageWrapper {
    protected KrbContext context;
    private String orgContentType = null;
    private static final int PLAIN_BUFFER_SIZE = 16384;
    private byte[] plainBuf;
    private int bufPos;
    private boolean initialized = false;
    protected KrbConfiguration config;

    public KrbOutputMessage(OutputMessage message, KrbContext context, KrbConfiguration config) {
        super(message);
        this.context = context;
        this.plainBuf = new byte[16384];
        this.config = config;
    }

    public void write(int b) throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.bufPos >= this.plainBuf.length) {
            this.flush();
        }
        this.plainBuf[this.bufPos++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int avail;
        if (!this.initialized) {
            this.initialize();
        }
        if (this.bufPos >= this.plainBuf.length) {
            this.flush();
        }
        if ((avail = this.plainBuf.length - this.bufPos) >= len) {
            System.arraycopy(b, off, this.plainBuf, this.bufPos, len);
            this.bufPos += len;
        } else {
            int writtenCount = 0;
            while (writtenCount < len) {
                if (avail >= len - writtenCount) {
                    System.arraycopy(b, off, this.plainBuf, this.bufPos, len - writtenCount);
                    this.bufPos += len - writtenCount;
                    writtenCount = len;
                    continue;
                }
                System.arraycopy(b, off, this.plainBuf, this.bufPos, avail);
                this.bufPos = this.plainBuf.length;
                this.flush();
                writtenCount += avail;
                off += avail;
                avail = this.plainBuf.length;
            }
        }
    }

    public void flush() throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.bufPos != 0) {
            byte[] encrypted;
            MessageProp msgProp = this.getMessageProp();
            try {
                encrypted = this.context.gssContext.wrap(this.plainBuf, 0, this.bufPos, msgProp);
            }
            catch (GSSException e) {
                if (e.getMajor() == 12) {
                    this.context.dispose();
                }
                throw new IOException(e.toString());
            }
            this.bufPos = 0;
            super.write(encrypted);
            super.flush();
        }
        super.flush();
    }

    protected abstract MessageProp getMessageProp();

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    private void initialize() {
        this.initialized = true;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (this.config.reqConf && this.config.privateState) {
            this.orgContentType = type;
        }
    }

    protected void initStream() throws IOException {
        if (this.config.reqConf && this.config.privateState) {
            this.setStringHeader("x-idoox-orig-type", this.orgContentType);
            this.setContentType("application/octet-stream");
        }
    }
}

