/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos;

import com.idoox.debug.Category;
import com.idoox.wasp.security.kerberos.KDCConfig;
import com.idoox.wasp.security.kerberos.KrbNameMapper;

public class KrbNameMapperImpl
extends KrbNameMapper {
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.kerberos.KrbNameMapperImpl");
    private static String DEFAULT_REALM = null;

    public String getWaspPrincipalName(String krbName) {
        if (DEFAULT_REALM == null) {
            return krbName;
        }
        int atId = krbName.lastIndexOf("@");
        if (atId == -1) {
            return krbName;
        }
        String realm = krbName.substring(atId + 1);
        if (DEFAULT_REALM.equalsIgnoreCase(realm)) {
            return krbName.substring(0, krbName.lastIndexOf("@"));
        }
        return krbName;
    }

    static {
        try {
            DEFAULT_REALM = KDCConfig.getInstance().getDefaultRealm();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

