/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos;

import com.idoox.debug.Category;
import com.idoox.wasp.security.kerberos.KrbClientInputMessage;
import com.idoox.wasp.security.kerberos.KrbClientOutputMessage;
import com.idoox.wasp.security.kerberos.KrbConfiguration;
import com.idoox.wasp.security.kerberos.KrbContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.idoox.config.Configurable;
import org.idoox.security.Credentials;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.StopProcessingException;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;

public class KrbClientInterceptor
implements TransportInterceptor {
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.kerberos.KrbClientInterceptor");
    public static final String IDOOX_SESSION_HDR = "x-idoox-sessionID";
    public static final String IDOOX_SESSION_INIT = "x-idoox-sessionInit";
    private static Hashtable contexts = new Hashtable(11, 0.75f);

    public void intercept(Connection connection, InterceptorChain chain, int position) throws StopProcessingException, IOException {
        Credentials cred = this.getClientCredentials();
        if (cred == null) {
            throw new RuntimeException("No credentials found.");
        }
        String userId = cred.getName();
        Subject subject = cred.getSubject();
        KrbConfiguration config = KrbClientInterceptor.getConfig();
        Context context = null;
        try {
            if (Current.getServiceEndpointContext() == null) {
                String uri = connection.getURI().toExternalForm();
                context = KrbClientInterceptor.getContext(uri, userId);
            }
            if (context == null) {
                context = this.createContext(connection, userId, subject, config);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Kerberos Authentication error. " + e.getClass().getName() + " " + (e.getMessage() == null ? "" : e.getMessage()));
        }
        connection.setInputMessage((InputMessage)new KrbClientInputMessage(connection.getInputMessage(), context, config));
        KrbClientOutputMessage outMsg = new KrbClientOutputMessage(connection.getOutputMessage(), context, config);
        outMsg.setStringHeader(IDOOX_SESSION_HDR, context.sessionID);
        connection.setOutputMessage((OutputMessage)outMsg);
    }

    static KrbConfiguration getConfig() {
        return new KrbConfiguration(Current.getServiceClientContext());
    }

    private Credentials getClientCredentials() {
        org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
        Map map = Current.getServiceClientContext().getContextData();
        Credentials[] creds = (Credentials[])map.get("Stub.credentials");
        if (creds == null || creds.length == 0) {
            creds = current.getCredentials();
        }
        if (creds == null || creds.length == 0) {
            return null;
        }
        int i = 0;
        while (i < creds.length) {
            if (creds[i] != null && creds[i].getProviderName().equals("Kerberos")) {
                return creds[i];
            }
            ++i;
        }
        return null;
    }

    public void load(Configurable config) throws WaspInternalException {
    }

    public void destroy() {
    }

    public static void putContext(String uri, String userId, Context context) {
        contexts.put(uri + "@" + userId, context);
    }

    public static Context getContext(String uri, String userId) {
        return (Context)contexts.get(uri + "@" + userId);
    }

    public static void removeContext(String uri, String userId) {
        contexts.remove(uri + "@" + userId);
    }

    public static void resetContext(String uri, String userId) {
        contexts.remove(uri + "@" + userId);
    }

    static void resetContexts() {
        contexts.clear();
    }

    private Context createContext(Connection connection, String userId, Subject subject, KrbConfiguration config) throws PrivilegedActionException {
        if (userId == null || userId.length() == 0) {
            Set<Principal> princSet = subject.getPrincipals();
            Iterator<Principal> it = princSet.iterator();
            while (it.hasNext()) {
                Principal obj = it.next();
                if (!obj.getClass().getName().equals("javax.security.auth.kerberos.KerberosPrincipal") || !(obj instanceof Principal)) continue;
                userId = obj.getName();
                break;
            }
        }
        try {
            Subject.doAs(subject, new GSSContextCreator(connection, userId, (InputStream)connection.getInputMessage(), (OutputStream)connection.getOutputMessage(), config));
        }
        catch (PrivilegedActionException e) {
            log.error("cannot create new context for krb authentication for user " + userId, (Throwable)e.getException());
            throw e;
        }
        catch (Throwable e) {
            log.error("cannot create new context for krb authentication for user " + userId, e);
        }
        String uri = connection.getURI().toExternalForm();
        Context ret = KrbClientInterceptor.getContext(uri, userId);
        return ret;
    }

    static class GSSContextCreator
    implements PrivilegedExceptionAction {
        private Connection connection;
        private String userId;
        InputStream inputStream;
        OutputStream outputStream;
        KrbConfiguration config;

        public Object run() throws Exception {
            String uri = this.connection.getURI().toExternalForm();
            Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
            Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
            String nameStr = this.config.getServiceName(new Endpoint(this.connection.getURI()));
            GSSName serverName = GSSManager.getInstance().createName(nameStr, krb5PrincipalNameType);
            GSSName userName = GSSManager.getInstance().createName(this.userId, GSSName.NT_USER_NAME);
            GSSCredential userCreds = GSSManager.getInstance().createCredential(userName, 0, krb5Oid, 1);
            GSSContext context = GSSManager.getInstance().createContext(serverName, krb5Oid, userCreds, 0);
            context.requestMutualAuth(this.config.reqMutualAuth);
            context.requestConf(this.config.reqConf);
            context.requestInteg(this.config.reqMic);
            InputStream inMsg = null;
            OutputMessage outMsg = null;
            String sessionID = null;
            while (!context.isEstablished()) {
                Endpoint sManagerURI = new Endpoint(uri);
                CallContext callContext = Current.getCallContext();
                Properties lookupProps = (Properties)callContext.getContextData().get("CallContext.lookupProperties");
                ClientConnection con = sManagerURI.newConnection(TransportMethod.POST, (Map)lookupProps);
                outMsg = con.getOutputMessage();
                outMsg.setContentType("application/octet-stream");
                if (sessionID != null) {
                    outMsg.setStringHeader(KrbClientInterceptor.IDOOX_SESSION_HDR, sessionID);
                }
                outMsg.setStringHeader(KrbClientInterceptor.IDOOX_SESSION_INIT, KrbClientInterceptor.IDOOX_SESSION_INIT);
                context.initSecContext(inMsg, (OutputStream)outMsg);
                outMsg.flush();
                outMsg.close();
                if (inMsg != null) {
                    if (inMsg.getStatusCode() != 200) {
                        throw new RuntimeException("Unable to establish secure channel to: " + uri + ", server returned: " + inMsg.getStatusCode());
                    }
                    inMsg.close();
                    inMsg = null;
                }
                inMsg = con.getInputMessage();
                if (sessionID != null) continue;
                sessionID = inMsg.getStringHeader(KrbClientInterceptor.IDOOX_SESSION_HDR);
            }
            if (inMsg != null) {
                inMsg.close();
                inMsg = null;
            }
            KrbClientInterceptor.putContext(uri, this.userId, new Context(this.userId, uri, context, sessionID));
            return null;
        }

        public GSSContextCreator(Connection connection, String userId, InputStream inputStream, OutputStream outputStream, KrbConfiguration config) {
            this.connection = connection;
            this.userId = userId;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
            this.config = config;
        }
    }

    static class Context
    extends KrbContext {
        String userId = null;
        String uri = null;
        String sessionID;

        public Context(String userId, String uri, GSSContext gssContext, String sessionID) {
            this.userId = userId;
            this.uri = uri;
            this.gssContext = gssContext;
            this.sessionID = sessionID;
        }

        public void dispose() {
            KrbClientInterceptor.removeContext(this.uri, this.userId);
        }
    }
}

