/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.interceptor;

import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.server.ReceivedCredentialsImpl;
import com.idoox.security.spkm.SpkmParseTokenResult;
import com.idoox.security.spkm.SpkmSupport;
import com.idoox.wasp.security.interceptor.InterceptorBase;
import com.idoox.wasp.security.interceptor.SecureInputMessage;
import com.idoox.wasp.security.interceptor.SecureOutputMessage;
import com.idoox.wasp.security.smanager.ContextData;
import com.idoox.wasp.security.smanager.SessionManager;
import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.monitoring.events.LogEventAuthFailed;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.config.Configurable;
import org.idoox.security.ContextExpiredException;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.server.ServerConnection;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.ietf.jgss.GSSException;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventManager;

public class ServerInterceptor
extends InterceptorBase {
    public void intercept(Connection connection, InterceptorChain intChain, int pos) {
        ServerConnection serverConnection = (ServerConnection)connection;
        try {
            if ("session_manager".equals(connection.getURI().getParameter("select"))) {
                return;
            }
            InputMessage inMsg = connection.getInputMessage();
            if (!"x-idoox/secured".equals(inMsg.getStringHeader("x-idoox-content-type"))) {
                RuntimeException e = new RuntimeException("Request is not secured; SPKM secured requests required");
                EventManager.fireEvent((Event)new LogEventAuthFailed("", "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
                throw e;
            }
            BufferedInputStream bufIn = new BufferedInputStream((InputStream)inMsg);
            bufIn.mark(200);
            SpkmParseTokenResult result = new SpkmParseTokenResult();
            SpkmSupport.spkmParseToken((InputStream)bufIn, (SpkmParseTokenResult)result);
            if (result.tokenType != 5) {
                RuntimeException e = new RuntimeException("Unexpected token type: " + SpkmSupport.tokenTypes[result.tokenType] + " received");
                EventManager.fireEvent((Event)new LogEventAuthFailed("", "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
                throw e;
            }
            bufIn.reset();
            Current current = Current.getInstance();
            String clientName = result.context.getTargName().toString();
            WaspCallbackHandler handler = new WaspCallbackHandler(clientName);
            ContextData contextData = SessionManager.getContextData(result.context);
            if (contextData == null) {
                RuntimeException e = new RuntimeException("Unable to get GSSContext info from Session Manager");
                EventManager.fireEvent((Event)new LogEventAuthFailed("", "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
                throw e;
            }
            current.setReceivedCredentials((ReceivedCredentials)new ReceivedCredentialsImpl(clientName, "SPKM", (CallbackHandler)handler, contextData.getAcceptingCredentials(), result.context));
            connection.setInputMessage((InputMessage)new SecureInputMessage(inMsg, bufIn, result.context, this, null));
            connection.setOutputMessage((OutputMessage)new SecureOutputMessage(connection.getOutputMessage(), result.context));
        }
        catch (IOException e) {
            EventManager.fireEvent((Event)new LogEventAuthFailed("", "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (GSSException e) {
            EventManager.fireEvent((Event)new LogEventAuthFailed("", "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
            if (e.getMajor() == 8) {
                connection.getOutputMessage().setStatusCode(408);
                try {
                    connection.getOutputMessage().close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                ServiceManagerImpl.faultGenerated.set(Boolean.TRUE);
                throw new ContextExpiredException("Security Context expired or not available");
            }
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void load(Configurable config) {
    }

    public void destroy() {
    }

    public void removeClientContext(String uri) {
    }
}

