/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.http.digest;

import com.idoox.security.httpdigest.HttpDigestHelper;
import java.util.Map;

public class AuthenticateStructure {
    String realm = null;
    String domain = null;
    String nonce = null;
    String opaque = null;
    String algorithm = null;
    String qop = null;
    String peer = null;
    boolean stalePresent = false;
    boolean stale = false;

    public AuthenticateStructure() {
    }

    public AuthenticateStructure(String challenge, String peer) {
        this.peer = peer;
        Map challengeMap = HttpDigestHelper.parseAuthentication((String)challenge);
        if (challengeMap == null) {
            throw new RuntimeException("Authentication method isn't digest.");
        }
        this.realm = (String)challengeMap.get("realm");
        this.domain = (String)challengeMap.get("domain");
        this.nonce = (String)challengeMap.get("nonce");
        this.opaque = (String)challengeMap.get("opaque");
        this.algorithm = (String)challengeMap.get("algorithm");
        this.qop = (String)challengeMap.get("qop");
        if (challengeMap.containsKey("stale")) {
            this.stalePresent = true;
            String staleStr = (String)challengeMap.get("stale");
            if ("TRUE".equals(staleStr)) {
                this.stale = true;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String prefix = " ";
        sb.append("Digest");
        if (this.realm != null) {
            sb.append(prefix).append("realm=\"").append(this.realm).append("\"");
            prefix = ", ";
        }
        if (this.domain != null) {
            sb.append(prefix).append("domain=\"").append(this.domain).append("\"");
            prefix = ", ";
        }
        if (this.nonce != null) {
            sb.append(prefix).append("nonce=\"").append(this.nonce).append("\"");
            prefix = ", ";
        }
        if (this.opaque != null) {
            sb.append(prefix).append("opaque=\"").append(this.opaque).append("\"");
            prefix = ", ";
        }
        if (this.algorithm != null) {
            sb.append(prefix).append("algorithm=\"").append(this.algorithm).append("\"");
            prefix = ", ";
        }
        if (this.qop != null) {
            sb.append(prefix).append("qop=\"").append(this.qop).append("\"");
            prefix = ", ";
        }
        if (this.stalePresent) {
            if (this.stale) {
                sb.append(prefix).append("stale=\"TRUE\"");
            } else {
                sb.append(prefix).append("stale=\"FALSE\"");
            }
            prefix = ", ";
        }
        return sb.toString();
    }

    public String getRealm() {
        return this.realm;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getQop() {
        return this.qop;
    }

    public String getPeer() {
        return this.peer;
    }
}

