/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.ca;

import com.idoox.security.util.Base64;
import com.idoox.security.x509.X500Name;
import com.idoox.wasp.Constants;
import com.idoox.wasp.security.ca.DBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.idoox.util.RuntimeWrappedException;

public class Database {
    private String workdir;

    public Database(String workdir) {
        this.workdir = workdir;
    }

    public boolean containsSubject(X500Name subject) {
        File file = new File(this.workdir + this.constructFileName(subject));
        return file.exists();
    }

    public X509Certificate getCertificate(X500Name subject) throws DBException {
        String filename = this.workdir + this.constructFileName(subject);
        File file = new File(filename);
        if (!file.exists()) {
            throw new DBException("Certificate does not exist for: " + subject.getName());
        }
        try {
            FileInputStream fin = new FileInputStream(filename);
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate retval = (X509Certificate)cf.generateCertificate(fin);
            fin.close();
            return retval;
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    public void storeCertificate(X500Name subject, X509Certificate cert, boolean replace) throws DBException {
        String filename = this.workdir + this.constructFileName(subject);
        File file = new File(filename);
        if (file.exists() && !replace) {
            throw new DBException("Certificate already exists for: " + subject.getName());
        }
        if ((file = file.getParentFile()) != null) {
            file.mkdirs();
        }
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            fout.write(cert.getEncoded());
            fout.close();
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    private String constructFileName(X500Name subject) {
        String retval;
        byte[] encoded = Base64.encode((byte[])subject.encode(), (boolean)false);
        if (encoded.length > 250) {
            int count = encoded.length / 250;
            StringBuffer sb = new StringBuffer(encoded.length + count - 1);
            String fileSep = System.getProperty("file.separator");
            int i = 0;
            while (i < count) {
                if (i != 0) {
                    sb.append(fileSep);
                }
                int length = i + 1 == count ? encoded.length % 250 : 250;
                byte[] part = new byte[length];
                System.arraycopy(encoded, i * 250, part, 0, length);
                try {
                    sb.append(new String(part, Constants.UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeWrappedException((Throwable)e);
                }
                ++i;
            }
            retval = sb.toString();
        } else {
            try {
                retval = new String(encoded, Constants.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
        }
        return retval;
    }
}

