/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.https.impl;

import com.idoox.security.spkm.GSSCredentialImpl;
import com.idoox.transport.https.SecurityUtils;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.idoox.security.Credentials;

public abstract class X509KeyManagerBase {
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers) {
        Credentials cred = this.getCredentials();
        if (cred == null) {
            return null;
        }
        GSSCredentialImpl gssCreds = SecurityUtils.getGSSCredentials(cred);
        String algorithm = gssCreds.getCertificate().getPublicKey().getAlgorithm();
        String ret = null;
        int i = 0;
        while (i < keyTypes.length) {
            if (algorithm.equals(keyTypes[i])) {
                ret = cred.getName();
                break;
            }
            ++i;
        }
        return ret;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers) {
        Credentials cred = this.getCredentials();
        if (cred == null) {
            return null;
        }
        GSSCredentialImpl gssCreds = SecurityUtils.getGSSCredentials(cred);
        String algorithm = gssCreds.getKey().getAlgorithm();
        String ret = algorithm.equals(keyType) ? cred.getName() : null;
        return ret;
    }

    public X509Certificate[] getCertificateChain(String alias) {
        Credentials cred = this.getCredentials();
        if (cred == null || !cred.getName().equals(alias)) {
            return null;
        }
        GSSCredentialImpl gss = SecurityUtils.getGSSCredentials(cred);
        if (gss == null) {
            return null;
        }
        X509Certificate[] chain = gss.getCertificates();
        return chain;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String alias = this.chooseClientAlias(new String[]{keyType}, issuers);
        String[] toRet = alias != null ? new String[]{alias} : null;
        return toRet;
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        String alias = this.chooseClientAlias(new String[]{keyType}, issuers);
        String[] toRet = alias != null ? new String[]{alias} : null;
        return toRet;
    }

    public PrivateKey getPrivateKey(String alias) {
        Credentials cred = this.getCredentials();
        if (cred == null || !cred.getName().equals(alias)) {
            return null;
        }
        GSSCredentialImpl gss = SecurityUtils.getGSSCredentials(cred);
        if (gss == null) {
            return null;
        }
        PrivateKey key = gss.getKey();
        return key;
    }

    protected abstract Credentials getCredentials();
}

