/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.https.impl;

import com.idoox.debug.Category;
import com.idoox.transport.https.impl.ClientX509KeyManagerBase;
import com.idoox.transport.https.impl.JSSEHelperProvider;
import com.idoox.transport.https.impl.ServerX509KeyManagerBase;
import com.idoox.transport.https.impl.X509TrustManagerBase;
import com.idoox.transport.https.impl.java14.JSSEHelperProvider_Java14;
import com.idoox.transport.https.impl.sun13.JSSEHelperProvider_Sun13;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateFactory;
import java.util.StringTokenizer;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import org.idoox.security.Credentials;
import org.idoox.wasp.WaspSecurity;

public class JSSEHelper {
    private static final Category log = Category.getCategory((String)"com.idoox.transport.https.impl.JSSEHelper");
    private static JSSEHelperProvider provider = null;
    private static String errorMessage = "Unable to create SSL socket factory. This can be caused by:\n Java1.4 - JSSE is not bundled with your JRE or JSSE provider is not listed in jre/lib/security/java.security file\n Java1.3 - JSSE is not installed in your JVM or its JSSE provider is not listed in jre/lib/security/java.security file.";

    private static void checkProviderExist() throws GeneralSecurityException {
        if (provider == null) {
            throw new GeneralSecurityException(errorMessage);
        }
    }

    public static SSLServerSocketFactory createSSLServerSocketFactory(String alias, String password) throws GeneralSecurityException, ClassNotFoundException, NoSuchProviderException {
        JSSEHelper.checkProviderExist();
        Credentials serverCreds = WaspSecurity.acquireServerCredentials((String)alias, (String)password, (String)"SSL");
        ServerX509KeyManagerBase keyManager = new ServerX509KeyManagerBase(serverCreds);
        X509TrustManagerBase trustManager = new X509TrustManagerBase();
        return provider.createSSLServerSocketFactory(keyManager, trustManager);
    }

    public static SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException, ClassNotFoundException {
        JSSEHelper.checkProviderExist();
        ClientX509KeyManagerBase keyManager = new ClientX509KeyManagerBase();
        X509TrustManagerBase trustManager = new X509TrustManagerBase();
        return provider.createSSLSocketFactory(keyManager, trustManager);
    }

    public static String getPeerName(SSLSocket sslSocket) throws SSLException {
        X509Certificate[] xcerts = sslSocket.getSession().getPeerCertificateChain();
        if (xcerts.length == 0) {
            throw new SSLException("No peer certificates available");
        }
        return JSSEHelper.getCommonName(xcerts[0].getSubjectDN().getName());
    }

    public static java.security.cert.X509Certificate[] getPeerCertificates(SSLSocket sslSocket) throws SSLException {
        X509Certificate[] xcerts = sslSocket.getSession().getPeerCertificateChain();
        if (xcerts.length == 0) {
            return new java.security.cert.X509Certificate[0];
        }
        java.security.cert.X509Certificate[] ret = new java.security.cert.X509Certificate[xcerts.length];
        try {
            int i = 0;
            while (i < xcerts.length) {
                X509Certificate xcert = xcerts[i];
                byte[] encoded = xcert.getEncoded();
                CertificateFactory fact = CertificateFactory.getInstance("X.509");
                ret[i] = (java.security.cert.X509Certificate)fact.generateCertificate(new ByteArrayInputStream(encoded));
                ++i;
            }
        }
        catch (Exception e) {
            throw new SSLException("Conversion from javax.security.cert.X509Certificate to java.security.cert.X509Certificate failed. Root cause:" + e.getMessage());
        }
        return ret;
    }

    public static String getCommonName(String x500Name) throws SSLException {
        StringTokenizer tknz = new StringTokenizer(x500Name, ",", false);
        while (tknz.hasMoreTokens()) {
            String current = tknz.nextToken().trim();
            if (!current.startsWith("CN=")) continue;
            return current.substring(3);
        }
        throw new SSLException("Wrong server certificate, CN was not found in its subject!");
    }

    private static void initProvider() {
        log.debug("trying Java1.4 JSSE ...");
        try {
            JSSEHelperProvider_Java14.canWork();
            provider = new JSSEHelperProvider_Java14();
            log.debug("Java1.4 JSSE available");
            return;
        }
        catch (Exception e) {
            log.debug("Java1.4 JSSE unavailable", (Throwable)e);
            try {
                JSSEHelperProvider_Sun13.canWork();
                provider = new JSSEHelperProvider_Sun13();
                log.debug("Sun1.3 JSSE available");
                return;
            }
            catch (Exception e2) {
                log.debug("Sun1.3 JSSE unavailable", (Throwable)e2);
                log.error(errorMessage);
                provider = null;
                return;
            }
        }
    }

    static {
        JSSEHelper.initProvider();
    }
}

