/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import java.io.InputStream;
import org.ietf.jgss.GSSException;

public class Oid {
    private com.idoox.security.asn1.Oid oid;

    public Oid(String strOid) throws GSSException {
        try {
            this.oid = new com.idoox.security.asn1.Oid(strOid);
        }
        catch (Asn1Exception e) {
            this.oid = null;
        }
    }

    public Oid(InputStream derOid) throws GSSException {
        try {
            this.oid = (com.idoox.security.asn1.Oid)Asn1.decode(derOid);
        }
        catch (Asn1Exception e) {
            throw new GSSException(13);
        }
    }

    public Oid(byte[] derOid) throws GSSException {
        try {
            this.oid = (com.idoox.security.asn1.Oid)Asn1.decode(derOid);
        }
        catch (Asn1Exception e) {
            throw new GSSException(13);
        }
    }

    static Oid getInstance(String strOid) {
        Oid retVal = null;
        try {
            retVal = new Oid(strOid);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return retVal;
    }

    public String toString() {
        return this.oid.getOid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Oid) {
            byte[] e2;
            Oid other = (Oid)obj;
            byte[] e1 = this.oid.encode();
            if (e1.length != (e2 = other.oid.encode()).length) {
                return false;
            }
            int i = 0;
            while (i < e1.length) {
                if (e1[i] != e2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        byte[] encoded = this.oid.encode();
        int retval = 0;
        int i = 0;
        while (i < encoded.length) {
            retval += encoded[i];
            ++i;
        }
        return retval;
    }

    public byte[] getDER() {
        return this.oid.encode();
    }

    public boolean containedIn(Oid[] oids) {
        int i = 0;
        while (i < oids.length) {
            if (this.equals(oids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

