/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.security;

public class AssociationOptions {
    public static final int NO_PROTECTION = 1;
    public static final int INTEGRITY = 2;
    public static final int CONFIDENTIALITY = 4;
    public static final int EST_TRUST_IN_CLIENT = 8;
    public static final int EST_TRUST_IN_TARGET = 16;
    public static final int NO_DELEGATION = 32;
    public static final int SIMPLE_DELEGATION = 64;
    public static final int COMPOSITE_DELEGATION = 128;
    private int options;

    public AssociationOptions(int value) {
        this.options = value;
    }

    public boolean getNoProtection() {
        return (this.options & 1) == 1;
    }

    public void setNoProtection(boolean value) {
        this.options = value ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
    }

    public boolean getIntegrity() {
        return (this.options & 2) == 2;
    }

    public void setIntegrity(boolean value) {
        this.options = value ? (this.options |= 2) : (this.options &= 0xFFFFFFFD);
    }

    public boolean getConfidentiality() {
        return (this.options & 4) == 4;
    }

    public void setConfidentiality(boolean value) {
        this.options = value ? (this.options |= 4) : (this.options &= 0xFFFFFFFB);
    }

    public boolean getEstTrustInClient() {
        return (this.options & 8) == 8;
    }

    public void setEstTrustInClient(boolean value) {
        this.options = value ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
    }

    public boolean getEstTrustInTarget() {
        return (this.options & 0x10) == 16;
    }

    public void setEstTrustInTarget(boolean value) {
        this.options = value ? (this.options |= 0x10) : (this.options &= 0xFFFFFFEF);
    }

    public boolean getNoDelegation() {
        return (this.options & 0x20) == 32;
    }

    public void setNoDelegation(boolean value) {
        this.options = value ? (this.options |= 0x20) : (this.options &= 0xFFFFFFDF);
    }

    public boolean getSimpleDelegation() {
        return (this.options & 0x40) == 64;
    }

    public void setSimpleDelegation(boolean value) {
        this.options = value ? (this.options |= 0x40) : (this.options &= 0xFFFFFFBF);
    }

    public boolean getCompositeDelegation() {
        return (this.options & 0x80) == 128;
    }

    public void setCompositeDelegation(boolean value) {
        this.options = value ? (this.options |= 0x80) : (this.options &= 0xFFFFFF7F);
    }
}

