/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.x509.RDN;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class X500Name
extends Sequence {
    private ArrayList rdns = new ArrayList();

    public X500Name(String dn) throws Asn1Exception {
        RDN rdn;
        StringTokenizer tknz = new StringTokenizer(dn, ",", false);
        String current = tknz.nextToken();
        StringBuffer sb = new StringBuffer(current);
        while (tknz.hasMoreTokens()) {
            current = tknz.nextToken();
            if (current.indexOf(61) == -1) {
                sb.append(",").append(current);
                continue;
            }
            if (current.indexOf(59) != -1 && current.indexOf(59) < current.indexOf(61)) {
                sb.append(",").append(current);
                continue;
            }
            rdn = new RDN(sb.toString());
            this.rdns.add(rdn);
            sb = new StringBuffer(current);
        }
        rdn = new RDN(sb.toString());
        this.rdns.add(rdn);
        Iterator ordered = new TreeSet(this.rdns).iterator();
        while (ordered.hasNext()) {
            this.addComponent((RDN)ordered.next());
        }
    }

    public X500Name(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public X500Name(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        int i = 0;
        while (i < this.components.size()) {
            this.rdns.add(new RDN(((Asn1)this.components.get(i)).encode()));
            ++i;
        }
    }

    public ArrayList getRDNs() {
        return this.rdns;
    }

    public String getName() {
        StringBuffer sb = new StringBuffer();
        Iterator ordered = new TreeSet(this.rdns).iterator();
        while (ordered.hasNext()) {
            sb.append(((RDN)ordered.next()).getName());
            if (!ordered.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object other) {
        if (other instanceof X500Name) {
            byte[] enc2;
            X500Name another = (X500Name)other;
            byte[] enc1 = this.encode();
            if (enc1.length != (enc2 = another.encode()).length) {
                return false;
            }
            int i = 1;
            while (i < enc1.length) {
                if (enc1[i] != enc2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        byte[] enc = this.encode();
        int hash = 0;
        int i = 1;
        while (i < enc.length) {
            hash += enc[i];
            ++i;
        }
        return hash;
    }
}

