/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Explicit;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Primitive;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import com.idoox.security.x509.Extensions;
import com.idoox.security.x509.SubjectPublicKeyInfo;
import com.idoox.security.x509.Validity;
import com.idoox.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import org.idoox.security.util.RuntimeWrappedException;

public class TBSCertificate
extends Sequence {
    private int version;
    private BigInteger serialNumber;
    private AlgorithmId signature;
    private X500Name issuer;
    private Validity validity;
    private X500Name subject;
    private SubjectPublicKeyInfo keyInfo;
    private byte[] issuerID;
    private byte[] subjectID;
    private Extensions exts;

    public TBSCertificate(int ver, BigInteger serialNumber, String sigAlgName, X500Name issuer, Validity validity, X500Name subject, SubjectPublicKeyInfo keyInfo, byte[] issuerID, byte[] subjectID, Extensions exts) {
        Implicit impl;
        Explicit exp;
        if (ver != 0) {
            this.version = ver;
            exp = new Explicit(-128, 0);
            exp.addComponent(new Integer(this.version));
            this.addComponent(exp);
        }
        this.serialNumber = serialNumber;
        this.addComponent(new Integer(this.serialNumber));
        try {
            this.signature = new AlgorithmId(OID.getAlgOid(sigAlgName));
        }
        catch (Asn1Exception e) {
            throw new RuntimeWrappedException(e);
        }
        this.addComponent(this.signature);
        this.issuer = issuer;
        this.addComponent(this.issuer);
        this.validity = validity;
        this.addComponent(this.validity);
        this.subject = subject;
        this.addComponent(this.subject);
        this.keyInfo = keyInfo;
        this.addComponent(this.keyInfo);
        if (issuerID != null) {
            if (this.version == 0) {
                throw new RuntimeException("Certificate must be v2 or v3 to have uniqueIssuerID");
            }
            this.issuerID = issuerID;
            impl = new Implicit(-128, 1);
            impl.addComponent(new BitString(this.issuerID));
            this.addComponent(impl);
        }
        if (subjectID != null) {
            if (this.version == 0) {
                throw new RuntimeException("Certificate must be v2 or v3 to have uniqueSubjectID");
            }
            this.subjectID = subjectID;
            impl = new Implicit(-128, 2);
            impl.addComponent(new BitString(this.subjectID));
            this.addComponent(impl);
        }
        if (exts != null) {
            if (this.version != 2) {
                throw new RuntimeException("Certificate must be v3 to have extensions");
            }
            this.exts = exts;
            exp = new Explicit(-128, 3);
            exp.addComponent(this.exts);
            this.addComponent(exp);
        }
    }

    public TBSCertificate(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public TBSCertificate(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        int i = 0;
        if (((Asn1)this.components.get(i)).getTagNumber() == 0) {
            Explicit exp = (Explicit)this.components.get(i);
            this.version = ((Integer)exp.getComponent()).getInt();
        }
        int n = ++i;
        this.serialNumber = ((Integer)this.components.get(n)).getBigInt();
        int n2 = ++i;
        this.signature = new AlgorithmId(((Asn1)this.components.get(n2)).encode());
        int n3 = ++i;
        this.issuer = new X500Name(((Asn1)this.components.get(n3)).encode());
        int n4 = ++i;
        this.validity = new Validity(((Asn1)this.components.get(n4)).encode());
        int n5 = ++i;
        this.subject = new X500Name(((Asn1)this.components.get(n5)).encode());
        int n6 = ++i;
        this.keyInfo = new SubjectPublicKeyInfo(((Asn1)this.components.get(n6)).encode());
        if (++i == this.components.size()) {
            return;
        }
        Asn1 comp = (Asn1)this.components.get(i);
        if (comp.getTagNumber() == 1) {
            this.issuerID = ((Primitive)comp).getBytes();
            if (++i == this.components.size()) {
                return;
            }
        }
        if ((comp = (Asn1)this.components.get(i)).getTagNumber() == 2) {
            this.subjectID = ((Primitive)comp).getBytes();
            if (++i == this.components.size()) {
                return;
            }
        }
        if ((comp = (Asn1)this.components.get(i)).getTagNumber() == 3) {
            Asn1 c = ((Explicit)comp).getComponent();
            this.exts = new Extensions(c.encode());
            if (++i != this.components.size()) {
                throw new Asn1Exception("Invalid encoding");
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmId getSignature() {
        return this.signature;
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.signature.getOid());
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public byte[] getIssuerID() {
        return this.issuerID;
    }

    public byte[] getSubjectID() {
        return this.subjectID;
    }

    public Extensions getExtensions() {
        return this.exts;
    }
}

