/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Asn1String;
import com.idoox.security.asn1.Boolean;
import com.idoox.security.asn1.Oid;
import com.idoox.security.asn1.Sequence;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class Extension
extends Sequence {
    protected String oid;
    protected boolean critical = false;
    protected byte[] value;

    protected Extension() {
    }

    public Extension(String oid, boolean critical, byte[] value) throws Asn1Exception {
        this.oid = oid;
        this.addComponent(new Oid(this.oid));
        this.critical = critical;
        this.addComponent(new Boolean(this.critical));
        this.value = value;
        this.addComponent(new Asn1String(this.value));
    }

    public Extension(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public Extension(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    protected void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        int i = 0;
        this.oid = ((Oid)this.components.get(i++)).getOid();
        try {
            this.critical = ((Boolean)this.components.get(i)).getTruth();
            ++i;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.value = ((Asn1String)this.components.get(i)).getBytes();
    }

    public String getOid() {
        return this.oid;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other instanceof Extension) {
            Extension another = (Extension)other;
            if (another.oid.equals(this.oid) && another.critical == this.critical) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode() + (this.critical ? 1 : 0);
    }
}

