/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import com.idoox.security.x509.TBSCertificate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Signature;
import org.idoox.security.util.RuntimeWrappedException;

public class Certificate
extends Sequence {
    private TBSCertificate tbsCertificate;
    private AlgorithmId sigAlg;
    private byte[] signature;

    public Certificate(TBSCertificate tbsCertificate, PrivateKey caKey) {
        this.tbsCertificate = tbsCertificate;
        this.addComponent(this.tbsCertificate);
        this.sigAlg = tbsCertificate.getSignature();
        this.addComponent(this.sigAlg);
        String sigAlgName = this.tbsCertificate.getSigAlgName();
        try {
            Signature sig = Signature.getInstance(sigAlgName);
            sig.initSign(caKey);
            sig.update(this.tbsCertificate.encode());
            this.signature = sig.sign();
            this.addComponent(new BitString(this.signature));
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public Certificate(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public Certificate(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.tbsCertificate = new TBSCertificate(((Asn1)this.components.get(0)).encode());
        this.sigAlg = new AlgorithmId(((Asn1)this.components.get(1)).encode());
        this.signature = ((BitString)this.components.get(2)).getBytes();
    }

    public TBSCertificate getTBSCertificate() {
        return this.tbsCertificate;
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.sigAlg.getOid());
    }

    public AlgorithmId getSigAlg() {
        return this.sigAlg;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

